/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import nl.jqno.equalsverifier.internal.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.instantiation.CachingValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.JavaApiPrefabValues;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.instantiation.vintage.VintageValueProvider;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FieldCache;
import nl.jqno.equalsverifier.internal.util.Configuration;

public final class Context<T> {
    private final Class<T> type;
    private final Configuration<T> configuration;
    private final ClassProbe<T> classProbe;
    private final FieldCache fieldCache;
    private final SubjectCreator<T> subjectCreator;
    private final ValueProvider valueProvider;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="FieldCache is inherently mutable")
    public Context(Configuration<T> configuration, FactoryCache factoryCache, FieldCache fieldCache, Objenesis objenesis) {
        this.type = configuration.getType();
        this.configuration = configuration;
        this.classProbe = ClassProbe.of(configuration.getType());
        this.fieldCache = fieldCache;
        FactoryCache cache = JavaApiPrefabValues.build().merge(factoryCache);
        VintageValueProvider vintage = new VintageValueProvider(cache, objenesis);
        CachingValueProvider caching = new CachingValueProvider(fieldCache, vintage);
        this.valueProvider = caching;
        this.subjectCreator = new SubjectCreator<T>(configuration, this.valueProvider, objenesis);
    }

    public Class<T> getType() {
        return this.type;
    }

    public Configuration<T> getConfiguration() {
        return this.configuration;
    }

    public ClassProbe<T> getClassProbe() {
        return this.classProbe;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="A cache is inherently mutable")
    public FieldCache getFieldCache() {
        return this.fieldCache;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="VintageValueProvider can use a mutable cache.")
    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public SubjectCreator<T> getSubjectCreator() {
        return this.subjectCreator;
    }
}

