/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import nl.jqno.equalsverifier.CheckReturnValue;
import nl.jqno.equalsverifier.EqualsVerifierReport;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.Mode;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.api.EqualsVerifierApi;
import nl.jqno.equalsverifier.internal.PrefabValuesApi;
import nl.jqno.equalsverifier.internal.checkers.AbstractDelegationChecker;
import nl.jqno.equalsverifier.internal.checkers.CachedHashCodeChecker;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.checkers.ExamplesChecker;
import nl.jqno.equalsverifier.internal.checkers.FieldsChecker;
import nl.jqno.equalsverifier.internal.checkers.HierarchyChecker;
import nl.jqno.equalsverifier.internal.checkers.MapEntryHashCodeRequirementChecker;
import nl.jqno.equalsverifier.internal.checkers.NullChecker;
import nl.jqno.equalsverifier.internal.checkers.RecordChecker;
import nl.jqno.equalsverifier.internal.checkers.SignatureChecker;
import nl.jqno.equalsverifier.internal.exceptions.MessagingException;
import nl.jqno.equalsverifier.internal.instantiation.UserPrefabValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.lib.objenesis.ObjenesisStd;
import nl.jqno.equalsverifier.internal.reflection.FieldCache;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.ErrorMessage;
import nl.jqno.equalsverifier.internal.util.FieldNameExtractor;
import nl.jqno.equalsverifier.internal.util.Formatter;
import nl.jqno.equalsverifier.internal.util.Validations;

public class SingleTypeEqualsVerifierApi<T>
implements EqualsVerifierApi<T> {
    private final Class<T> type;
    private final Set<String> actualFields;
    private EnumSet<Warning> warningsToSuppress = EnumSet.noneOf(Warning.class);
    private Set<Mode> modesToSet = new HashSet<Mode>();
    private boolean usingGetClass = false;
    private boolean hasRedefinedSuperclass = false;
    private Class<? extends T> redefinedSubclass = null;
    private UserPrefabValueProvider userPrefabs = new UserPrefabValueProvider();
    private FactoryCache factoryCache = new FactoryCache();
    private FieldCache fieldCache = new FieldCache();
    private CachedHashCodeInitializer<T> cachedHashCodeInitializer = CachedHashCodeInitializer.passthrough();
    private Function<String, String> fieldnameToGetter = null;
    private Set<String> allExcludedFields = new HashSet<String>();
    private Set<String> allIncludedFields = new HashSet<String>();
    private Set<String> nonnullFields = new HashSet<String>();
    private Set<String> ignoredAnnotationClassNames = new HashSet<String>();
    private List<T> equalExamples = new ArrayList<T>();
    private List<T> unequalExamples = new ArrayList<T>();
    private final Objenesis objenesis;

    public SingleTypeEqualsVerifierApi(Class<T> type) {
        this(type, new ObjenesisStd());
    }

    private SingleTypeEqualsVerifierApi(Class<T> type, Objenesis objenesis) {
        this.type = type;
        this.actualFields = FieldNameExtractor.extractFieldNames(type);
        this.objenesis = objenesis;
    }

    SingleTypeEqualsVerifierApi(Class<T> type, EnumSet<Warning> warningsToSuppress, Set<Mode> modes, UserPrefabValueProvider userPrefabs, FactoryCache factoryCache, Objenesis objenesis, boolean usingGetClass, Function<String, String> converter) {
        this(type, objenesis);
        this.warningsToSuppress = EnumSet.copyOf(warningsToSuppress);
        this.modesToSet = new HashSet<Mode>(modes);
        this.userPrefabs = userPrefabs;
        this.factoryCache = this.factoryCache.merge(factoryCache);
        this.usingGetClass = usingGetClass;
        this.fieldnameToGetter = converter;
    }

    SingleTypeEqualsVerifierApi(Class<T> type, List<T> equalExamples, List<T> unequalExamples) {
        this(type, new ObjenesisStd());
        this.equalExamples = equalExamples;
        this.unequalExamples = unequalExamples;
    }

    @Override
    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> suppress(Warning ... warnings) {
        Collections.addAll(this.warningsToSuppress, warnings);
        Validations.validateWarnings(this.warningsToSuppress);
        Validations.validateWarningsAndFields(this.warningsToSuppress, this.allIncludedFields, this.allExcludedFields);
        Validations.validateNonnullFields(this.nonnullFields, this.warningsToSuppress);
        return this;
    }

    @Override
    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> set(Mode ... modes) {
        Collections.addAll(this.modesToSet, modes);
        return this;
    }

    @Override
    @CheckReturnValue
    public <S> SingleTypeEqualsVerifierApi<T> withPrefabValues(Class<S> otherType, S red, S blue) {
        PrefabValuesApi.addPrefabValues(this.userPrefabs, this.objenesis, otherType, red, blue);
        return this;
    }

    @CheckReturnValue
    public <S> SingleTypeEqualsVerifierApi<T> withPrefabValuesForField(String fieldName, S red, S blue) {
        Validations.validateFieldNamesExist(this.type, Arrays.asList(fieldName), this.actualFields);
        PrefabValuesApi.addPrefabValuesForField(this.fieldCache, this.objenesis, this.type, fieldName, red, blue);
        return this.withNonnullFields(fieldName);
    }

    @Override
    @CheckReturnValue
    public <S> SingleTypeEqualsVerifierApi<T> withGenericPrefabValues(Class<S> otherType, Func.Func1<?, S> factory) {
        PrefabValuesApi.addGenericPrefabValues(this.factoryCache, otherType, factory);
        return this;
    }

    @Override
    @CheckReturnValue
    public <S> SingleTypeEqualsVerifierApi<T> withGenericPrefabValues(Class<S> otherType, Func.Func2<?, ?, S> factory) {
        PrefabValuesApi.addGenericPrefabValues(this.factoryCache, otherType, factory);
        return this;
    }

    @Override
    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> usingGetClass() {
        this.usingGetClass = true;
        return this;
    }

    @Override
    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> withFieldnameToGetterConverter(Function<String, String> converter) {
        this.fieldnameToGetter = converter;
        return this;
    }

    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> withIgnoredFields(String ... fields) {
        return this.withFieldsAddedAndValidated(this.allExcludedFields, Arrays.asList(fields));
    }

    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> withOnlyTheseFields(String ... fields) {
        return this.withFieldsAddedAndValidated(this.allIncludedFields, Arrays.asList(fields));
    }

    private SingleTypeEqualsVerifierApi<T> withFieldsAddedAndValidated(Set<String> collection, List<String> specifiedFields) {
        collection.addAll(specifiedFields);
        Validations.validateFields(this.allIncludedFields, this.allExcludedFields);
        Validations.validateFieldNamesExist(this.type, specifiedFields, this.actualFields);
        Validations.validateWarningsAndFields(this.warningsToSuppress, this.allIncludedFields, this.allExcludedFields);
        return this;
    }

    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> withNonnullFields(String ... fields) {
        List<String> fieldsAsList = Arrays.asList(fields);
        this.nonnullFields.addAll(fieldsAsList);
        Validations.validateFieldNamesExist(this.type, fieldsAsList, this.actualFields);
        Validations.validateNonnullFields(this.nonnullFields, this.warningsToSuppress);
        return this;
    }

    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> withIgnoredAnnotations(Class<?> ... annotations) {
        Validations.validateGivenAnnotations(annotations);
        for (Class<?> ignoredAnnotation : annotations) {
            this.ignoredAnnotationClassNames.add(ignoredAnnotation.getCanonicalName());
        }
        return this;
    }

    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> withRedefinedSuperclass() {
        this.hasRedefinedSuperclass = true;
        return this;
    }

    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> withRedefinedSubclass(Class<? extends T> subclass) {
        this.redefinedSubclass = subclass;
        return this;
    }

    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> withCachedHashCode(String cachedHashCodeField, String calculateHashCodeMethod, T example) {
        this.cachedHashCodeInitializer = new CachedHashCodeInitializer<T>(this.type, cachedHashCodeField, calculateHashCodeMethod, example);
        return this;
    }

    @CheckReturnValue
    public SingleTypeEqualsVerifierApi<T> withLombokCachedHashCode(T example) {
        this.cachedHashCodeInitializer = CachedHashCodeInitializer.lombokCachedHashcode(example);
        return this;
    }

    public void verify() {
        try {
            this.performVerification();
        }
        catch (MessagingException e) {
            throw new AssertionError(this.buildErrorMessage(e.getDescription(), true), e);
        }
        catch (Throwable e) {
            throw new AssertionError(this.buildErrorMessage(e.getMessage(), true), e);
        }
    }

    public EqualsVerifierReport report() {
        return this.report(true);
    }

    public EqualsVerifierReport report(boolean showUrl) {
        try {
            this.performVerification();
            return EqualsVerifierReport.success(this.type);
        }
        catch (MessagingException e) {
            return EqualsVerifierReport.failure(this.type, this.buildErrorMessage(e.getDescription(), showUrl), e);
        }
        catch (Throwable e) {
            return EqualsVerifierReport.failure(this.type, this.buildErrorMessage(e.getMessage(), showUrl), e);
        }
    }

    private String buildErrorMessage(String description, boolean showUrl) {
        String message = description == null ? "<no message>" : description;
        Object result = Formatter.of("EqualsVerifier found a problem in class %%.\n-> %%", this.type.getName(), message).format();
        if (showUrl) {
            result = (String)result + "\n\n" + ErrorMessage.suffix();
        }
        return result;
    }

    private void performVerification() {
        if (this.type.isEnum() || this.type.isInterface()) {
            return;
        }
        Validations.validateClassCanBeVerified(this.type);
        Configuration<T> config = this.buildConfig();
        Context<T> context = new Context<T>(config, this.userPrefabs, this.factoryCache, this.fieldCache, this.objenesis);
        Validations.validateProcessedAnnotations(this.type, config.getAnnotationCache(), this.warningsToSuppress, this.allIncludedFields, this.allExcludedFields);
        this.verifyWithoutExamples(context);
        this.verifyWithExamples(context);
    }

    private Configuration<T> buildConfig() {
        return Configuration.build(this.type, this.allExcludedFields, this.allIncludedFields, this.nonnullFields, this.fieldCache.getFieldNames(), this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress, this.modesToSet, this.fieldnameToGetter, this.ignoredAnnotationClassNames, this.actualFields, this.equalExamples, this.unequalExamples);
    }

    private void verifyWithoutExamples(Context<T> context) {
        Checker[] checkers;
        Configuration<T> config = context.getConfiguration();
        for (Checker checker : checkers = new Checker[]{new SignatureChecker<T>(context), new AbstractDelegationChecker<T>(context), new NullChecker<T>(context), new RecordChecker<T>(context), new CachedHashCodeChecker<T>(config)}) {
            checker.check();
        }
    }

    private void verifyWithExamples(Context<T> context) {
        Checker[] checkers;
        for (Checker checker : checkers = new Checker[]{new ExamplesChecker<T>(context), new HierarchyChecker<T>(context), new FieldsChecker<T>(context), new MapEntryHashCodeRequirementChecker<T>(context)}) {
            checker.check();
        }
    }
}

