/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.Instantiator;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class HierarchyChecker<T>
implements Checker {
    private final Configuration<T> config;
    private final Class<T> type;
    private final SubjectCreator<T> subjectCreator;
    private final ClassProbe<T> classProbe;
    private final Class<? extends T> redefinedSubclass;
    private final boolean strictnessSuppressed;
    private final boolean versionedEntity;
    private final boolean hasRedefinedSubclass;
    private final boolean typeIsFinal;
    private final boolean typeIsSealed;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public HierarchyChecker(Context<T> context) {
        this.config = context.getConfiguration();
        this.strictnessSuppressed = this.config.getWarningsToSuppress().contains((Object)Warning.STRICT_INHERITANCE);
        this.versionedEntity = this.config.getWarningsToSuppress().contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY);
        boolean bl = this.hasRedefinedSubclass = this.config.getRedefinedSubclass() != null;
        if (this.strictnessSuppressed && this.hasRedefinedSubclass) {
            Assert.fail(Formatter.of("withRedefinedSubclass and weakInheritanceCheck are mutually exclusive.", new Object[0]));
        }
        this.type = context.getType();
        this.subjectCreator = context.getSubjectCreator();
        this.classProbe = context.getClassProbe();
        this.redefinedSubclass = this.config.getRedefinedSubclass();
        this.typeIsFinal = Modifier.isFinal(this.type.getModifiers());
        this.typeIsSealed = this.classProbe.isSealed();
        this.cachedHashCodeInitializer = this.config.getCachedHashCodeInitializer();
    }

    @Override
    public void check() {
        this.checkSuperclass();
        this.checkSubclass();
        this.checkRedefinedSubclass();
        this.checkFinalEqualsMethod();
    }

    private void checkSuperclass() {
        ClassProbe<T> superProbe = this.classProbe.getSuperProbe();
        if (superProbe.isEqualsInheritedFromObject() || superProbe.isSealed()) {
            return;
        }
        if (this.config.hasRedefinedSuperclass() || this.config.isUsingGetClass()) {
            T reference = this.subjectCreator.plain();
            Object equalSuper = this.getEqualSuper(reference);
            Formatter formatter = Formatter.of("Redefined superclass:\n  %%\nshould not equal superclass instance\n  %%\nbut it does.", reference, equalSuper);
            try {
                Assert.assertFalse(formatter, reference.equals(equalSuper) || equalSuper.equals(reference));
            }
            catch (AbstractMethodError abstractMethodError) {}
        } else {
            this.safelyCheckSuperProperties(this.subjectCreator.plain(), this.subjectCreator.withAllFieldsShallowlyChanged());
            if (this.versionedEntity) {
                Predicate<Field> p = f -> !this.config.getAnnotationCache().hasFieldAnnotation(this.type, f.getName(), SupportedAnnotations.ID);
                this.safelyCheckSuperProperties(this.subjectCreator.withAllMatchingFieldsDefaulted(p), this.subjectCreator.withAllFieldsShallowlyChanged());
            } else {
                this.safelyCheckSuperProperties(this.subjectCreator.withAllFieldsDefaulted(), this.subjectCreator.withAllFieldsShallowlyChanged());
            }
        }
    }

    private void safelyCheckSuperProperties(T reference, T shallowScrambled) {
        if (this.strictnessSuppressed) {
            return;
        }
        Object equalSuper = this.getEqualSuper(reference);
        try {
            this.checkSuperProperties(reference, equalSuper, shallowScrambled);
        }
        catch (AbstractMethodError | NullPointerException throwable) {
            // empty catch block
        }
    }

    private void checkSuperProperties(T reference, Object equalSuper, T shallow) {
        Formatter symmetryFormatter = Formatter.of("Symmetry:\n  %%\ndoes not equal superclass instance\n  %%", reference, equalSuper);
        Assert.assertTrue(symmetryFormatter, reference.equals(equalSuper) && equalSuper.equals(reference));
        Formatter transitivityFormatter = Formatter.of("Transitivity:\n  %%\nand\n  %%\nboth equal superclass instance\n  %%\nwhich implies they equal each other.", reference, shallow, equalSuper);
        Assert.assertTrue(transitivityFormatter, reference.equals(shallow) || reference.equals(equalSuper) != equalSuper.equals(shallow));
        int referenceHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(reference);
        int equalSuperHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(equalSuper);
        Formatter superclassFormatter = Formatter.of("Superclass: hashCode for\n  %% (%%)\nshould be equal to hashCode for superclass instance\n  %% (%%)", reference, referenceHashCode, equalSuper, equalSuperHashCode);
        Assert.assertTrue(superclassFormatter, referenceHashCode == equalSuperHashCode);
    }

    private Object getEqualSuper(T reference) {
        return this.subjectCreator.copyIntoSuperclass(reference);
    }

    private void checkSubclass() {
        if (this.typeIsFinal || this.typeIsSealed || this.strictnessSuppressed) {
            return;
        }
        T reference = this.subjectCreator.plain();
        Class<?> realClass = reference.getClass();
        Class<?> anonymousSubclass = Instantiator.giveDynamicSubclass(realClass);
        Object equalSub = this.subjectCreator.copyIntoSubclass(reference, anonymousSubclass);
        if (this.config.isUsingGetClass()) {
            Formatter formatter = Formatter.of("Subclass: object is equal to an instance of a trivial subclass with equal fields:\n  %%\nThis should not happen when using getClass().", reference);
            Assert.assertFalse(formatter, reference.equals(equalSub));
        } else {
            Formatter formatter = Formatter.of("Subclass: object is not equal to an instance of a trivial subclass with equal fields:\n  %%\nMaybe you forgot to add usingGetClass(). Otherwise, consider making the class final or use EqualsVerifier.simple().", reference);
            Assert.assertTrue(formatter, reference.equals(equalSub));
        }
    }

    private void checkRedefinedSubclass() {
        if (this.typeIsFinal || this.typeIsSealed || !this.hasRedefinedSubclass) {
            return;
        }
        if (this.methodIsFinal("equals", Object.class)) {
            Assert.fail(Formatter.of("Subclass: %% has a final equals method.\nNo need to supply a redefined subclass.", this.type.getSimpleName()));
        }
        T reference = this.subjectCreator.plain();
        T redefinedSub = this.subjectCreator.copyIntoSubclass(reference, this.redefinedSubclass);
        Assert.assertFalse(Formatter.of("Subclass:\n  %%\nequals subclass instance\n  %%", reference, redefinedSub), reference.equals(redefinedSub));
    }

    private void checkFinalEqualsMethod() {
        boolean isEntity = this.config.getAnnotationCache().hasClassAnnotation(this.type, SupportedAnnotations.ENTITY);
        if (this.strictnessSuppressed || isEntity || this.typeIsFinal || this.hasRedefinedSubclass) {
            return;
        }
        boolean equalsIsFinal = this.methodIsFinal("equals", Object.class);
        boolean hashCodeIsFinal = this.methodIsFinal("hashCode", new Class[0]);
        if (this.config.isUsingGetClass()) {
            Assert.assertEquals(Formatter.of("Finality: equals and hashCode must both be final or both be non-final.", new Object[0]), equalsIsFinal, hashCodeIsFinal);
        } else {
            Formatter equalsFormatter = Formatter.of("Subclass: equals is not final.\nMake your class or your equals method final, or supply an instance of a redefined subclass using withRedefinedSubclass if equals cannot be final.", new Object[0]);
            Assert.assertTrue(equalsFormatter, equalsIsFinal);
            Formatter hashCodeFormatter = Formatter.of("Subclass: hashCode is not final.\nMake your class or your hashCode method final, or supply an instance of a redefined subclass using withRedefinedSubclass if hashCode cannot be final.", new Object[0]);
            Assert.assertTrue(hashCodeFormatter, hashCodeIsFinal);
        }
    }

    private boolean methodIsFinal(String methodName, Class<?> ... parameterTypes) {
        return Rethrow.rethrow(() -> {
            Method method = this.type.getMethod(methodName, parameterTypes);
            return Modifier.isFinal(method.getModifiers());
        });
    }
}

