/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.prefab;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import nl.jqno.equalsverifier.internal.instantiation.prefab.ValueSupplier;
import nl.jqno.equalsverifier.internal.reflection.Tuple;

class JavaTimeValueSupplier<T>
extends ValueSupplier<T> {
    public JavaTimeValueSupplier(Class<T> type) {
        super(type);
    }

    @Override
    public Optional<Tuple<T>> get() {
        if (this.is(Clock.class)) {
            return this.val(Clock.systemUTC(), Clock.system(ZoneId.of("-10")), Clock.systemUTC());
        }
        if (this.is(Duration.class)) {
            return this.val(Duration.ZERO, Duration.ofDays(1L), Duration.ZERO);
        }
        if (this.is(Instant.class)) {
            return this.val(Instant.MIN, Instant.MAX, Instant.MIN);
        }
        if (this.is(LocalDateTime.class)) {
            return this.val(LocalDateTime.MIN, LocalDateTime.MAX, LocalDateTime.MIN);
        }
        if (this.is(LocalDate.class)) {
            return this.val(LocalDate.MIN, LocalDate.MAX, LocalDate.MIN);
        }
        if (this.is(LocalTime.class)) {
            return this.val(LocalTime.MIN, LocalTime.MAX, LocalTime.MIN);
        }
        if (this.is(MonthDay.class)) {
            return this.val(MonthDay.of(1, 1), MonthDay.of(12, 31), MonthDay.of(1, 1));
        }
        if (this.is(OffsetDateTime.class)) {
            return this.val(OffsetDateTime.MIN, OffsetDateTime.MAX, OffsetDateTime.MIN);
        }
        if (this.is(OffsetTime.class)) {
            return this.val(OffsetTime.MIN, OffsetTime.MAX, OffsetTime.MIN);
        }
        if (this.is(Period.class)) {
            return this.val(Period.ZERO, Period.of(1, 1, 1), Period.ZERO);
        }
        if (this.is(Year.class)) {
            return this.val(Year.of(2000), Year.of(2010), Year.of(2000));
        }
        if (this.is(YearMonth.class)) {
            return this.val(YearMonth.of(2000, 1), YearMonth.of(2010, 12), YearMonth.of(2000, 1));
        }
        if (this.is(ZoneId.class)) {
            return this.val(ZoneId.of("+1"), ZoneId.of("-10"), ZoneId.of("+1"));
        }
        if (this.is(ZoneOffset.class)) {
            return this.val(ZoneOffset.ofHours(1), ZoneOffset.ofHours(-1), ZoneOffset.ofHours(1));
        }
        if (this.is(ZonedDateTime.class)) {
            return this.val(ZonedDateTime.parse("2017-12-13T10:15:30+01:00"), ZonedDateTime.parse("2016-11-12T09:14:29-01:00"), ZonedDateTime.parse("2017-12-13T10:15:30+01:00"));
        }
        return Optional.empty();
    }
}

