/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.api;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import nl.jqno.equalsverifier.CheckReturnValue;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.Mode;
import nl.jqno.equalsverifier.ScanOption;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.api.EqualsVerifierApi;
import nl.jqno.equalsverifier.api.MultipleTypeEqualsVerifierApi;
import nl.jqno.equalsverifier.api.SingleTypeEqualsVerifierApi;
import nl.jqno.equalsverifier.internal.PrefabValuesApi;
import nl.jqno.equalsverifier.internal.instantiation.UserPrefabValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.lib.objenesis.ObjenesisStd;
import nl.jqno.equalsverifier.internal.reflection.PackageScanOptions;
import nl.jqno.equalsverifier.internal.reflection.PackageScanner;
import nl.jqno.equalsverifier.internal.util.FieldToPrefabValues;
import nl.jqno.equalsverifier.internal.util.ListBuilders;
import nl.jqno.equalsverifier.internal.util.Validations;

public final class ConfiguredEqualsVerifier
implements EqualsVerifierApi<Void> {
    private final EnumSet<Warning> warningsToSuppress;
    private final Set<Mode> modesToSet;
    private final UserPrefabValueProvider userPrefabs;
    private final FactoryCache factoryCache;
    private boolean usingGetClass;
    private Function<String, String> fieldnameToGetter;
    private final Objenesis objenesis = new ObjenesisStd();

    public ConfiguredEqualsVerifier() {
        this(EnumSet.noneOf(Warning.class), new HashSet<Mode>(), new UserPrefabValueProvider(), new FactoryCache(), false, null);
    }

    private ConfiguredEqualsVerifier(EnumSet<Warning> warningsToSuppress, Set<Mode> modes, UserPrefabValueProvider userPrefabs, FactoryCache factoryCache, boolean usingGetClass, Function<String, String> fieldnameToGetter) {
        this.warningsToSuppress = warningsToSuppress;
        this.modesToSet = modes;
        this.userPrefabs = userPrefabs;
        this.factoryCache = factoryCache;
        this.usingGetClass = usingGetClass;
        this.fieldnameToGetter = fieldnameToGetter;
    }

    @CheckReturnValue
    public ConfiguredEqualsVerifier copy() {
        return new ConfiguredEqualsVerifier(EnumSet.copyOf(this.warningsToSuppress), new HashSet<Mode>(this.modesToSet), this.userPrefabs.copy(), this.factoryCache.copy(), this.usingGetClass, this.fieldnameToGetter);
    }

    @CheckReturnValue
    public ConfiguredEqualsVerifier suppress(Warning ... warnings) {
        Collections.addAll(this.warningsToSuppress, warnings);
        return this;
    }

    public ConfiguredEqualsVerifier set(Mode ... modes) {
        Collections.addAll(this.modesToSet, modes);
        return this;
    }

    @CheckReturnValue
    public <S> ConfiguredEqualsVerifier withPrefabValues(Class<S> otherType, S red, S blue) {
        PrefabValuesApi.addPrefabValues(this.userPrefabs, this.objenesis, otherType, red, blue);
        return this;
    }

    @CheckReturnValue
    public <S> ConfiguredEqualsVerifier withGenericPrefabValues(Class<S> otherType, Func.Func1<?, S> factory) {
        PrefabValuesApi.addGenericPrefabValues(this.factoryCache, otherType, factory);
        return this;
    }

    @CheckReturnValue
    public <S> ConfiguredEqualsVerifier withGenericPrefabValues(Class<S> otherType, Func.Func2<?, ?, S> factory) {
        PrefabValuesApi.addGenericPrefabValues(this.factoryCache, otherType, factory);
        return this;
    }

    @CheckReturnValue
    public ConfiguredEqualsVerifier usingGetClass() {
        this.usingGetClass = true;
        return this;
    }

    @CheckReturnValue
    public ConfiguredEqualsVerifier withFieldnameToGetterConverter(Function<String, String> converter) {
        this.fieldnameToGetter = converter;
        return this;
    }

    @CheckReturnValue
    public <T> SingleTypeEqualsVerifierApi<T> forClass(Class<T> type) {
        return new SingleTypeEqualsVerifierApi<T>(type, EnumSet.copyOf(this.warningsToSuppress), new HashSet<Mode>(this.modesToSet), this.userPrefabs.copy(), this.factoryCache.copy(), this.objenesis, this.usingGetClass, this.fieldnameToGetter);
    }

    @CheckReturnValue
    public <T> SingleTypeEqualsVerifierApi<T> forExamples(T red, T blue) {
        Validations.validateRedAndBlueExamples(red, blue);
        Class<?> type = red.getClass();
        SingleTypeEqualsVerifierApi<?> api = this.forClass(type);
        FieldToPrefabValues.move(api, type, red, blue);
        return api;
    }

    @CheckReturnValue
    public MultipleTypeEqualsVerifierApi forClasses(Iterable<Class<?>> classes) {
        return new MultipleTypeEqualsVerifierApi(ListBuilders.fromIterable(classes), this);
    }

    @CheckReturnValue
    public MultipleTypeEqualsVerifierApi forClasses(Class<?> first, Class<?> second, Class<?> ... more) {
        return new MultipleTypeEqualsVerifierApi(ListBuilders.buildListOfAtLeastTwo(first, second, more), this);
    }

    @CheckReturnValue
    public MultipleTypeEqualsVerifierApi forPackage(String packageName, ScanOption ... options) {
        PackageScanOptions opts = PackageScanOptions.process(options);
        List<Class<?>> classes = PackageScanner.getClassesIn(packageName, opts);
        Validations.validatePackageContainsClasses(packageName, classes);
        return new MultipleTypeEqualsVerifierApi(classes, this);
    }
}

