/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;

public class SignificantFieldCheck<T>
implements FieldCheck<T> {
    private final SubjectCreator<T> subjectCreator;
    private final Configuration<T> config;
    private final Class<T> type;
    private final EnumSet<Warning> warningsToSuppress;
    private final Set<String> ignoredFields;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;
    private final AnnotationCache annotationCache;
    private final Predicate<FieldProbe> isCachedHashCodeField;

    public SignificantFieldCheck(Context<T> context, Predicate<FieldProbe> isCachedHashCodeField) {
        this.subjectCreator = context.getSubjectCreator();
        this.config = context.getConfiguration();
        this.type = this.config.type();
        this.warningsToSuppress = this.config.warningsToSuppress();
        this.ignoredFields = this.config.ignoredFields();
        this.cachedHashCodeInitializer = this.config.cachedHashCodeInitializer();
        this.annotationCache = this.config.annotationCache();
        this.isCachedHashCodeField = isCachedHashCodeField;
    }

    @Override
    public void execute(FieldProbe fieldProbe) {
        if (this.isCachedHashCodeField.test(fieldProbe)) {
            return;
        }
        this.checkValues(this.subjectCreator.plain(), this.subjectCreator.plain(), this.subjectCreator.withFieldChanged(fieldProbe.getField()), fieldProbe, false);
        if (fieldProbe.canBeDefault(this.config)) {
            this.checkValues(this.subjectCreator.withAllFieldsDefaulted(), this.subjectCreator.withAllFieldsDefaulted(), this.subjectCreator.withAllFieldsDefaultedExcept(fieldProbe.getField()), fieldProbe, true);
        }
    }

    private void checkValues(T reference, T copy, T changed, FieldProbe probe, boolean testWithNull) {
        String fieldName = probe.getField().getName();
        boolean equalToItself = reference.equals(copy);
        boolean equalsChanged = !reference.equals(changed);
        boolean hashCodeChanged = this.cachedHashCodeInitializer.getInitializedHashCode(reference) != this.cachedHashCodeInitializer.getInitializedHashCode(changed);
        this.assertEqualsAndHashCodeRelyOnSameFields(equalsChanged, hashCodeChanged, reference, changed, fieldName, testWithNull);
        this.assertFieldShouldBeIgnored(equalToItself, equalsChanged, reference, probe, fieldName, testWithNull);
    }

    private void assertEqualsAndHashCodeRelyOnSameFields(boolean equalsChanged, boolean hashCodeChanged, T reference, T changed, String fieldName, boolean testWithNull) {
        if (equalsChanged != hashCodeChanged) {
            Formatter formatter;
            boolean skipEqualsHasMoreThanHashCodeTest;
            boolean bl = skipEqualsHasMoreThanHashCodeTest = this.warningsToSuppress.contains((Object)Warning.STRICT_HASHCODE) || testWithNull;
            if (!skipEqualsHasMoreThanHashCodeTest) {
                formatter = Formatter.of("Significant fields: equals relies on %%, but hashCode does not.\n  %% has hashCode %%\n  %% has hashCode %%", fieldName, reference, reference.hashCode(), changed, changed.hashCode());
                Assert.assertFalse(formatter, equalsChanged);
            }
            formatter = Formatter.of("Significant fields: hashCode relies on %%, but equals does not.\nThese objects are equal, but probably shouldn't be:\n  %%\nand\n  %%", fieldName, reference, changed);
            Assert.assertFalse(formatter, hashCodeChanged);
        }
    }

    private void assertFieldShouldBeIgnored(boolean equalToItself, boolean equalsChanged, T object, FieldProbe fieldProbe, String fieldName, boolean testWithNull) {
        boolean anotherFieldIsMarkedAsId;
        if (!this.shouldAllFieldsBeUsed(fieldProbe) || !this.isFieldEligible(fieldProbe)) {
            return;
        }
        boolean fieldShouldBeIgnored = this.ignoredFields.contains(fieldName);
        boolean thisFieldIsMarkedAsId = this.annotationCache.hasFieldAnnotation(this.type, fieldName, SupportedAnnotations.ID);
        boolean bl = anotherFieldIsMarkedAsId = !thisFieldIsMarkedAsId && this.annotationCache.hasClassAnnotation(this.type, SupportedAnnotations.ID);
        if (!this.fieldIsEmptyAndItsOk(thisFieldIsMarkedAsId, fieldProbe, object)) {
            if (!fieldShouldBeIgnored) {
                Assert.assertTrue(Formatter.of("Significant fields: equals does not use %%.", fieldName), equalToItself);
            }
            this.assertFieldShouldHaveBeenUsed(fieldName, equalsChanged, fieldShouldBeIgnored, thisFieldIsMarkedAsId, anotherFieldIsMarkedAsId);
        }
        this.assertFieldShouldNotBeUsed(fieldName, equalsChanged, fieldShouldBeIgnored, thisFieldIsMarkedAsId, anotherFieldIsMarkedAsId, testWithNull);
    }

    private boolean shouldAllFieldsBeUsed(FieldProbe fieldProbe) {
        return !this.warningsToSuppress.contains((Object)Warning.ALL_FIELDS_SHOULD_BE_USED) && (!this.warningsToSuppress.contains((Object)Warning.ALL_NONFINAL_FIELDS_SHOULD_BE_USED) || fieldProbe.isFinal());
    }

    private boolean isFieldEligible(FieldProbe fieldProbe) {
        return !fieldProbe.isStatic() && !fieldProbe.isTransient() && !fieldProbe.isEmptyOrSingleValueEnum() && !this.annotationCache.hasFieldAnnotation(this.type, fieldProbe.getField().getName(), SupportedAnnotations.TRANSIENT);
    }

    private boolean fieldIsEmptyAndItsOk(boolean thisFieldIsMarkedAsId, FieldProbe fieldProbe, T object) {
        Object value = fieldProbe.getValue(object);
        Class<?> fieldType = fieldProbe.getType();
        Object zero = PrimitiveMappers.DEFAULT_WRAPPED_VALUE_MAPPER.get(fieldType);
        boolean fieldIsEmpty = value == null || value.equals(zero);
        return thisFieldIsMarkedAsId && this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY) && fieldIsEmpty;
    }

    private void assertFieldShouldHaveBeenUsed(String fieldName, boolean equalsChanged, boolean fieldShouldBeIgnored, boolean thisFieldIsMarkedAsId, boolean anotherFieldIsMarkedAsId) {
        String message = thisFieldIsMarkedAsId ? "Significant fields: %% is marked @Id or @EmbeddedId and Warning.SURROGATE_KEY is suppressed, but equals does not use it." : (anotherFieldIsMarkedAsId ? "Significant fields: equals does not use %%, or it is stateless.\nSuppress Warning.SURROGATE_KEY if you want to use only the @Id or @EmbeddedId field(s)." : "Significant fields: equals does not use %%, or it is stateless.");
        Assert.assertTrue(Formatter.of(message, fieldName), fieldShouldBeIgnored || equalsChanged);
    }

    private void assertFieldShouldNotBeUsed(String fieldName, boolean equalsChanged, boolean fieldShouldBeIgnored, boolean thisFieldIsMarkedAsId, boolean anotherFieldIsMarkedAsId, boolean testWithNull) {
        String message = thisFieldIsMarkedAsId ? "Significant fields: %% is marked @Id or @EmbeddedId so equals should not use it, but it does.\nSuppress Warning.SURROGATE_KEY if you want to use only the @Id or @EmbeddedId field(s)." : (anotherFieldIsMarkedAsId ? "Significant fields: equals should not use %% because Warning.SURROGATE_KEY is suppressed and it is not marked as @Id or @EmbeddedId, but it does." : "Significant fields: equals should not use %%, but it does.");
        Assert.assertTrue(Formatter.of(message, fieldName), !fieldShouldBeIgnored || !equalsChanged || testWithNull);
    }
}

