/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.vintage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import nl.jqno.equalsverifier.internal.exceptions.RecursionException;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.instantiation.vintage.factories.FallbackFactory;
import nl.jqno.equalsverifier.internal.instantiation.vintage.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class VintageValueProvider
implements ValueProvider {
    private final Map<TypeTag, Tuple<?>> valueCache = new HashMap();
    private final ValueProvider prefabs;
    private final FactoryCache factoryCache;
    private final PrefabValueFactory<?> fallbackFactory;

    public VintageValueProvider(ValueProvider prefabs, FactoryCache factoryCache, Objenesis objenesis) {
        this.prefabs = prefabs;
        this.factoryCache = factoryCache;
        this.fallbackFactory = new FallbackFactory(objenesis);
    }

    @Override
    public <T> Optional<Tuple<T>> provide(TypeTag tag, String fieldName) {
        return Rethrow.rethrow(() -> Optional.of(this.giveTuple(tag)));
    }

    public <T> T giveRed(TypeTag tag) {
        return this.giveTuple(tag).red();
    }

    public <T> T giveBlue(TypeTag tag) {
        return this.giveTuple(tag).blue();
    }

    public <T> T giveRedCopy(TypeTag tag) {
        return this.giveTuple(tag).redCopy();
    }

    public <T> T giveOther(TypeTag tag, T value, LinkedHashSet<TypeTag> typeStack) {
        Class type = tag.getType();
        if (value != null && !type.isAssignableFrom(value.getClass()) && !this.wraps(type, value.getClass())) {
            throw new ReflectionException("TypeTag does not match value.");
        }
        Tuple<T> tuple = this.giveTuple(tag, typeStack);
        if (tuple.red() == null) {
            return null;
        }
        if (type.isArray() && this.arraysAreDeeplyEqual(tuple.red(), value)) {
            return tuple.blue();
        }
        if (!type.isArray() && value != null) {
            try {
                if (tuple.red().equals(value)) {
                    return tuple.blue();
                }
            }
            catch (AbstractMethodError e) {
                return tuple.red();
            }
        }
        return tuple.red();
    }

    private boolean wraps(Class<?> expectedClass, Class<?> actualClass) {
        return PrimitiveMappers.PRIMITIVE_OBJECT_MAPPER.get(expectedClass) == actualClass;
    }

    private boolean arraysAreDeeplyEqual(Object x, Object y) {
        return Arrays.deepEquals(new Object[]{x}, new Object[]{y});
    }

    public <T> void realizeCacheFor(TypeTag tag, LinkedHashSet<TypeTag> typeStack) {
        if (!this.valueCache.containsKey(tag)) {
            Tuple<T> tuple = this.createTuple(tag, typeStack);
            this.valueCache.put(tag, tuple);
        }
    }

    private <T> Tuple<T> giveTuple(TypeTag tag) {
        return this.giveTuple(tag, new LinkedHashSet<TypeTag>());
    }

    private <T> Tuple<T> giveTuple(TypeTag tag, LinkedHashSet<TypeTag> typeStack) {
        this.realizeCacheFor(tag, typeStack);
        return this.valueCache.get(tag);
    }

    private <T> Tuple<T> createTuple(TypeTag tag, LinkedHashSet<TypeTag> typeStack) {
        if (typeStack.contains(tag)) {
            throw new RecursionException(typeStack);
        }
        Optional userPrefab = this.prefabs.provide(tag, null);
        if (userPrefab.isPresent()) {
            Tuple result = userPrefab.get();
            return result;
        }
        Class type = tag.getType();
        if (this.factoryCache.contains(type)) {
            PrefabValueFactory factory = this.factoryCache.get(type);
            return factory.createValues(tag, this, typeStack);
        }
        Tuple<?> result = this.fallbackFactory.createValues(tag, this, typeStack);
        return result;
    }
}

