/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.SuperclassIterable;

public final class FieldIterable
implements Iterable<FieldProbe> {
    private final Class<?> type;
    private final boolean includeSuperclasses;
    private final boolean includeStatic;
    private final boolean isKotlin;

    private FieldIterable(Class<?> type, boolean includeSuperclasses, boolean includeStatic, boolean isKotlin) {
        this.type = type;
        this.includeSuperclasses = includeSuperclasses;
        this.includeStatic = includeStatic;
        this.isKotlin = isKotlin;
    }

    public static FieldIterable of(Class<?> type) {
        return new FieldIterable(type, true, true, false);
    }

    public static FieldIterable ofKotlin(Class<?> type) {
        return new FieldIterable(type, true, true, true);
    }

    public static FieldIterable ofIgnoringSuper(Class<?> type) {
        return new FieldIterable(type, false, true, false);
    }

    public static FieldIterable ofIgnoringStatic(Class<?> type) {
        return new FieldIterable(type, true, false, false);
    }

    public static FieldIterable ofIgnoringSuperAndStatic(Class<?> type) {
        return new FieldIterable(type, false, false, false);
    }

    @Override
    public Iterator<FieldProbe> iterator() {
        return this.createFieldList().iterator();
    }

    private List<FieldProbe> createFieldList() {
        if (this.isKotlin) {
            return this.createKotlinFieldList();
        }
        return this.createJavaFieldList();
    }

    private List<FieldProbe> createJavaFieldList() {
        ArrayList<FieldProbe> result = new ArrayList<FieldProbe>();
        result.addAll(this.addFieldsFor(this.type));
        if (this.includeSuperclasses) {
            for (Class<?> c : SuperclassIterable.of(this.type)) {
                result.addAll(this.addFieldsFor(c));
            }
        }
        return result;
    }

    private List<FieldProbe> createKotlinFieldList() {
        ArrayList<FieldProbe> result = new ArrayList<FieldProbe>();
        result.addAll(this.addFieldsFor(this.type));
        Set names = result.stream().map(FieldProbe::getName).collect(Collectors.toSet());
        if (this.includeSuperclasses) {
            for (Class<?> c : SuperclassIterable.of(this.type)) {
                List<FieldProbe> superFields = this.addFieldsFor(c).stream().filter(p -> !names.contains(p.getName())).toList();
                result.addAll(superFields);
                superFields.stream().map(FieldProbe::getName).forEach(names::add);
            }
        }
        return result;
    }

    private List<FieldProbe> addFieldsFor(Class<?> c) {
        ArrayList<FieldProbe> fields = new ArrayList<FieldProbe>();
        ArrayList<FieldProbe> statics = new ArrayList<FieldProbe>();
        for (Field field : c.getDeclaredFields()) {
            FieldProbe probe = FieldProbe.of(field);
            if (field.isSynthetic() && !probe.isKotlinDelegate() || probe.getName().startsWith("bitmap$init$") || probe.getName().equals("__cobertura_counters")) continue;
            boolean isStatic = probe.isStatic();
            if (isStatic && this.includeStatic) {
                statics.add(probe);
            }
            if (isStatic) continue;
            fields.add(probe);
        }
        ArrayList<FieldProbe> result = new ArrayList<FieldProbe>();
        result.addAll(fields);
        result.addAll(statics);
        return result;
    }
}

