/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.reflection.PackageScanOptions;
import nl.jqno.equalsverifier.internal.util.Rethrow;
import nl.jqno.equalsverifier.internal.util.Validations;

public final class PackageScanner {
    private PackageScanner() {
    }

    public static List<Class<?>> getClassesIn(String packageName, PackageScanOptions options) {
        String packagePath = packageName.replace('.', '/');
        List<Class<Class<?>>> result = PackageScanner.getResources(packagePath).flatMap(r -> PackageScanner.processResource(r, packagePath, options)).map(f -> PackageScanner.fileToClass(f, packagePath)).filter(c -> !c.isAnonymousClass()).filter(c -> !c.isLocalClass()).filter(c -> !c.getName().endsWith("Test")).filter(c -> options.mustExtend() == null || options.mustExtend().isAssignableFrom((Class<?>)c) && !options.mustExtend().equals(c)).collect(Collectors.toList());
        Validations.validateTypesAreKnown(options.exceptClasses(), result);
        result.removeAll(options.exceptClasses());
        result.removeIf(options.exclusionPredicate());
        return result;
    }

    private static Stream<URL> getResources(String packagePath) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return Rethrow.rethrow(() -> Collections.list(cl.getResources(packagePath)).stream(), e -> "Could not resolve package " + packagePath + ": " + e.getMessage());
    }

    private static Stream<File> processResource(URL resource, String packagePath, PackageScanOptions options) {
        return Rethrow.rethrow(() -> switch (resource.toURI().getScheme()) {
            case "file" -> PackageScanner.processDirectory(resource, options.scanRecursively());
            case "jar" -> {
                if (options.ignoreExternalJars()) {
                    yield Stream.empty();
                }
                yield PackageScanner.walkJar(resource, packagePath, options.scanRecursively());
            }
            default -> throw new ReflectionException("Could not resolve " + resource.toURI().getScheme() + " resource " + String.valueOf(resource));
        }, e -> "Could not resolve resource " + String.valueOf(resource) + ": " + e.getMessage());
    }

    private static Stream<File> processDirectory(URL resource, boolean scanRecursively) throws URISyntaxException {
        String path = resource.toURI().getPath();
        return PackageScanner.walkDirectory(new File(path), scanRecursively);
    }

    private static Stream<File> walkDirectory(File dir, boolean scanRecursively) {
        if (!dir.exists()) {
            return Stream.empty();
        }
        return Arrays.stream(dir.listFiles()).filter(f -> scanRecursively && f.isDirectory() || f.getName().endsWith(".class")).flatMap(f -> f.isDirectory() ? PackageScanner.walkDirectory(f, scanRecursively) : Stream.of(f));
    }

    private static Stream<File> walkJar(URL resource, String packagePath, boolean scanRecursively) throws IOException {
        String path = resource.getPath();
        String jar = path.substring(5, path.indexOf("!"));
        int packageSegments = packagePath.split("/").length;
        try (JarFile file = new JarFile(jar);){
            Stream<File> stream = file.stream().map(e -> e.getName()).filter(e -> e.endsWith(".class")).filter(e -> e.startsWith(packagePath)).filter(e -> scanRecursively || e.split("/").length == packageSegments + 1).map(e -> new File((String)e)).toList().stream();
            return stream;
        }
    }

    private static Class<?> fileToClass(File f, String packagePath) {
        String className = f.getName().substring(0, f.getName().length() - 6);
        String fullPath = f.getParent();
        String packageName = fullPath.substring(fullPath.indexOf(packagePath)).replace("/", ".");
        return Rethrow.rethrow(() -> Class.forName(packageName + "." + className), e -> "Could not resolve class " + className + ", which was found in package " + packageName);
    }
}

