/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class RecordProbe<T> {
    private final Class<T> type;

    public RecordProbe(Class<T> type) {
        this.type = type;
    }

    public Stream<FieldProbe> fields() {
        return StreamSupport.stream(FieldIterable.ofIgnoringStatic(this.type).spliterator(), false);
    }

    public T callRecordConstructor(List<?> params) {
        Constructor constructor = this.getRecordConstructor();
        return (T)Rethrow.rethrow(() -> constructor.newInstance(params.toArray(new Object[0])), e -> this.buildMessage((Throwable)e, params));
    }

    private Constructor<T> getRecordConstructor() {
        return Rethrow.rethrow(() -> {
            List<Class> constructorTypes = this.fields().map(FieldProbe::getType).collect(Collectors.toList());
            Constructor<T> result = this.type.getDeclaredConstructor(constructorTypes.toArray(new Class[0]));
            result.setAccessible(true);
            return result;
        });
    }

    private String buildMessage(Throwable e, List<?> params) {
        String prefix = "Record: failed to run constructor for record type " + this.type.getName() + "\n   These were the values passed to the constructor: " + String.valueOf(params);
        if (e.getCause() instanceof NullPointerException) {
            return prefix + "\n   If the record does not accept null values for its constructor parameters, consider suppressing Warning.NULL_FIELDS.";
        }
        boolean hasZeros = false;
        boolean hasSomethingElse = false;
        for (Object p : params) {
            if (PrimitiveMappers.ZEROS.contains(p)) {
                hasZeros = true;
                continue;
            }
            hasSomethingElse = true;
        }
        String msg = prefix;
        if (hasZeros) {
            msg = msg + "\n   If the record does not accept 0 or false as a value for its constructor parameters,consider suppressing Warning.ZERO_FIELDS.";
        }
        if (hasSomethingElse) {
            msg = msg + "\n   If the record does not accept any of the given values for its constructor parameters,consider providing prefab values for the types of those fields.";
        }
        return msg;
    }
}

