/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.lang.reflect.Field;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.reflection.FieldMutator;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;

public class NullPointerExceptionFieldCheck<T>
implements FieldCheck<T> {
    private final Configuration<T> config;
    private final SubjectCreator<T> subjectCreator;

    public NullPointerExceptionFieldCheck(Context<T> context) {
        this.config = context.getConfiguration();
        this.subjectCreator = context.getSubjectCreator();
    }

    @Override
    public void execute(FieldProbe fieldProbe) {
        if (this.config.nonnullFields().contains(fieldProbe.getName())) {
            return;
        }
        if (fieldProbe.isPrimitive()) {
            return;
        }
        if (fieldProbe.isAnnotatedNonnull(this.config.annotationCache())) {
            return;
        }
        if (fieldProbe.isStatic()) {
            T reference = this.subjectCreator.plain();
            FieldMutator fieldMutator = new FieldMutator(fieldProbe);
            Object saved = fieldProbe.getValue(reference);
            fieldMutator.setNewValue(reference, PrimitiveMappers.DEFAULT_VALUE_MAPPER.get(fieldProbe.getType()));
            this.performTests(fieldProbe.getField(), this.subjectCreator.plain(), this.subjectCreator.plain());
            fieldMutator.setNewValue(reference, saved);
        } else {
            T changed = this.subjectCreator.withFieldDefaulted(fieldProbe.getField());
            this.performTests(fieldProbe.getField(), this.subjectCreator.plain(), changed);
        }
    }

    private void performTests(Field field, Object reference, Object changed) {
        this.handle("equals", "the parameter's field", field, () -> reference.equals(changed));
        this.handle("equals", "the 'this' object's field", field, () -> changed.equals(reference));
        this.handle("hashCode", "field", field, () -> this.config.cachedHashCodeInitializer().getInitializedHashCode(changed));
    }

    private void handle(String testedMethodName, String whichOne, Field field, Runnable r) {
        try {
            r.run();
        }
        catch (NullPointerException e) {
            this.npeThrown(testedMethodName, whichOne, field, e);
        }
        catch (AbstractMethodError e) {
            this.abstractMethodErrorThrown(testedMethodName, field, e);
        }
        catch (ClassCastException e) {
            this.classCastExceptionThrown(field, e);
        }
        catch (Exception e) {
            this.exceptionThrown(testedMethodName, field, e);
        }
    }

    private void npeThrown(String method, String whichOne, Field field, NullPointerException e) {
        Formatter f = Formatter.of("Non-nullity: %% throws NullPointerException on %% %%.", method, whichOne, field.getName());
        Assert.fail(f, e);
    }

    private void abstractMethodErrorThrown(String method, Field field, AbstractMethodError e) {
        Formatter f = Formatter.of("Abstract delegation: %% throws AbstractMethodError when field %% is null.\nSuppress Warning.NULL_FIELDS to disable this check.", method, field.getName());
        Assert.fail(f, e);
    }

    private void classCastExceptionThrown(Field field, ClassCastException e) {
        Formatter f = Formatter.of("Generics: ClassCastException was thrown. Consider using withGenericPrefabValues for %%.", field.getType().getSimpleName());
        Assert.fail(f, e);
    }

    private void exceptionThrown(String method, Field field, Exception e) {
        Formatter f = Formatter.of("%% throws %% when field %% is null.", method, e.getClass().getSimpleName(), field.getName());
        Assert.fail(f, e);
    }
}

