/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.prefab;

import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;
import nl.jqno.equalsverifier.internal.instantiation.prefab.ValueSupplier;
import nl.jqno.equalsverifier.internal.reflection.Tuple;

class JavaUtilConcurrentValueSupplier<T>
extends ValueSupplier<T> {
    public JavaUtilConcurrentValueSupplier(Class<T> type) {
        super(type);
    }

    @Override
    public Optional<Tuple<T>> get() {
        if (this.is(Semaphore.class)) {
            Semaphore red = new Semaphore(1);
            return this.val(red, new Semaphore(1), red);
        }
        if (this.is(SynchronousQueue.class)) {
            SynchronousQueue red = new SynchronousQueue();
            return this.val(red, new SynchronousQueue(), red);
        }
        if (this.is(AtomicBoolean.class)) {
            return this.val(new AtomicBoolean(true), new AtomicBoolean(false), new AtomicBoolean(true));
        }
        if (this.is(AtomicInteger.class)) {
            return this.val(new AtomicInteger(1), new AtomicInteger(2), new AtomicInteger(1));
        }
        if (this.is(AtomicIntegerArray.class)) {
            return this.val(new AtomicIntegerArray(new int[]{1}), new AtomicIntegerArray(new int[]{2}), new AtomicIntegerArray(new int[]{1}));
        }
        if (this.is(AtomicLong.class)) {
            return this.val(new AtomicLong(1L), new AtomicLong(2L), new AtomicLong(1L));
        }
        if (this.is(AtomicLongArray.class)) {
            return this.val(new AtomicLongArray(new long[]{1L}), new AtomicLongArray(new long[]{2L}), new AtomicLongArray(new long[]{1L}));
        }
        if (this.is(DoubleAdder.class)) {
            DoubleAdder red = new DoubleAdder();
            return this.val(red, new DoubleAdder(), red);
        }
        if (this.is(DoubleAccumulator.class)) {
            DoubleAccumulator red = new DoubleAccumulator((a, b) -> a + b, 0.0);
            DoubleAccumulator blue = new DoubleAccumulator((a, b) -> a * b, 1.0);
            return this.val(red, blue, red);
        }
        if (this.is(LongAdder.class)) {
            LongAdder red = new LongAdder();
            return this.val(red, new LongAdder(), red);
        }
        if (this.is(LongAccumulator.class)) {
            LongAccumulator red = new LongAccumulator((a, b) -> a + b, 0L);
            LongAccumulator blue = new LongAccumulator((a, b) -> a * b, 1L);
            return this.val(red, blue, red);
        }
        if (this.is(StampedLock.class)) {
            StampedLock red = new StampedLock();
            return this.val(red, new StampedLock(), red);
        }
        if (this.is(ReentrantLock.class)) {
            ReentrantLock red = new ReentrantLock();
            return this.val(red, new ReentrantLock(), red);
        }
        return Optional.empty();
    }
}

