/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.vintage;

import java.util.HashMap;
import java.util.Map;
import nl.jqno.equalsverifier.internal.instantiation.vintage.factories.PrefabValueFactory;

public class FactoryCache {
    private final Map<String, PrefabValueFactory<?>> cache = new HashMap();

    public <T> void put(Class<?> type, PrefabValueFactory<T> factory) {
        if (type != null) {
            this.cache.put(type.getName(), factory);
        }
    }

    public <T> void put(String typeName, PrefabValueFactory<T> factory) {
        if (typeName != null) {
            this.cache.put(typeName, factory);
        }
    }

    public <T> PrefabValueFactory<T> get(Class<T> type) {
        if (type == null) {
            return null;
        }
        return this.cache.get(type.getName());
    }

    public boolean contains(Class<?> type) {
        return this.cache.containsKey(type.getName());
    }

    public FactoryCache copy() {
        FactoryCache result = new FactoryCache();
        this.addAll(result, this);
        return result;
    }

    public FactoryCache merge(FactoryCache other) {
        FactoryCache result = new FactoryCache();
        this.addAll(result, this);
        this.addAll(result, other);
        return result;
    }

    private void addAll(FactoryCache to, FactoryCache from) {
        for (Map.Entry<String, PrefabValueFactory<?>> entry : from.cache.entrySet()) {
            to.put(entry.getKey(), entry.getValue());
        }
    }
}

