/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Modifier;
import java.util.Optional;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;

public final class SealedTypesFinder {
    private SealedTypesFinder() {
    }

    public static <T, U extends T> Optional<Class<U>> findInstantiableSubclass(Class<T> type) {
        return SealedTypesFinder.findInstantiablePermittedClass(type, false);
    }

    private static <T, U extends T> Optional<Class<U>> findInstantiablePermittedClass(Class<T> type, boolean checkCurrent) {
        if (!(!checkCurrent || SealedTypesFinder.isAbstract(type) && type.isSealed())) {
            Class<T> result = type;
            return Optional.of(result);
        }
        Class<?>[] permittedSubclasses = type.getPermittedSubclasses();
        if (permittedSubclasses == null) {
            return Optional.empty();
        }
        for (Class<?> permitted : permittedSubclasses) {
            Class<?> subType = permitted;
            Optional<Class<U>> c = SealedTypesFinder.findInstantiablePermittedClass(subType, true);
            if (!c.isPresent()) continue;
            return c;
        }
        throw new EqualsVerifierInternalBugException("Could not find a non-sealed subtype for " + type.getCanonicalName());
    }

    private static boolean isAbstract(Class<?> type) {
        return Modifier.isAbstract(type.getModifiers());
    }
}

