/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.exceptions.AssertionException;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class ExamplesChecker<T>
implements Checker {
    private final Class<T> type;
    private final List<T> equalExamples;
    private final List<T> unequalExamples;
    private final SubjectCreator<T> subjectCreator;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public ExamplesChecker(Context<T> context) {
        Configuration<T> config = context.getConfiguration();
        this.type = config.type();
        this.equalExamples = config.equalExamples();
        this.unequalExamples = config.unequalExamples();
        this.subjectCreator = context.getSubjectCreator();
        this.cachedHashCodeInitializer = config.cachedHashCodeInitializer();
    }

    @Override
    public void check() {
        this.checkPreconditions();
        for (int i = 0; i < this.equalExamples.size(); ++i) {
            T reference = this.equalExamples.get(i);
            this.checkSingle(reference);
            for (int j = i + 1; j < this.equalExamples.size(); ++j) {
                T other = this.equalExamples.get(j);
                this.checkEqualButNotIdentical(reference, other);
                this.checkHashCode(reference, other);
            }
        }
        List<T> unequals = this.ensureEnoughExamples(this.unequalExamples);
        for (T reference : unequals) {
            this.checkSingle(reference);
        }
    }

    private List<T> ensureEnoughExamples(List<T> examples) {
        if (examples.size() > 0) {
            return examples;
        }
        ArrayList<T> result = new ArrayList<T>();
        result.add(this.subjectCreator.plain());
        result.add(this.subjectCreator.withAllFieldsChanged());
        return result;
    }

    private void checkPreconditions() {
        for (T example : this.equalExamples) {
            Assert.assertTrue(Formatter.of("Precondition:\n  %%\nand\n  %%\nare of different classes", this.equalExamples.get(0), example), this.type.isAssignableFrom(example.getClass()));
        }
    }

    private void checkEqualButNotIdentical(T reference, T other) {
        Assert.assertFalse(Formatter.of("Precondition: the same object appears twice:\n  %%", reference), reference == other);
        Assert.assertFalse(Formatter.of("Precondition: two identical objects appear:\n  %%", reference), this.isIdentical(reference, other));
        Assert.assertTrue(Formatter.of("Precondition: not all equal objects are equal:\n  %%\nand\n  %%", reference, other), reference.equals(other));
    }

    private void checkSingle(T reference) {
        T copy = this.subjectCreator.copy(reference);
        this.checkReflexivity(reference);
        this.checkNonNullity(reference);
        this.checkTypeCheck(reference);
        this.checkHashCode(reference, copy);
    }

    private void checkReflexivity(T reference) {
        try {
            Assert.assertEquals(Formatter.of("Reflexivity: object does not equal itself:\n  %%", reference), reference, reference);
        }
        catch (ClassCastException e) {
            Formatter f = Formatter.of("Generics: ClassCastException was thrown.\nConsider using withPrefabValuesForField, withGenericPrefabValues, or forExamples for the type that triggered the exception.", new Object[0]);
            Assert.fail(f, e);
        }
    }

    private void checkNonNullity(T reference) {
        try {
            boolean nullity = reference.equals(null);
            Assert.assertFalse(Formatter.of("Non-nullity: true returned for null value", new Object[0]), nullity);
        }
        catch (NullPointerException e) {
            Assert.fail(Formatter.of("Non-nullity: NullPointerException thrown", new Object[0]), e);
        }
    }

    private void checkTypeCheck(T reference) {
        SomethingElse somethingElse = new SomethingElse();
        try {
            Formatter f = Formatter.of("Type-check: equals returns true for an unrelated type.\nAdd an instanceof or getClass() check.", new Object[0]);
            Assert.assertFalse(f, reference.equals(somethingElse));
        }
        catch (AssertionException e) {
            throw e;
        }
        catch (ClassCastException e) {
            Formatter f = Formatter.of("Type-check: equals throws ClassCastException.\nAdd an instanceof or getClass() check.", new Object[0]);
            Assert.fail(f, e);
        }
        catch (Exception e) {
            Formatter f = Formatter.of("Type-check: equals throws %%.\nAdd an instanceof or getClass() check.", e.getClass().getSimpleName());
            Assert.fail(f, e);
        }
    }

    private void checkHashCode(T reference, T copy) {
        int referenceHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(reference);
        Assert.assertEquals(Formatter.of("hashCode: hashCode should be consistent:\n  %% (%%)", reference, referenceHashCode), referenceHashCode, this.cachedHashCodeInitializer.getInitializedHashCode(reference));
        if (!reference.equals(copy)) {
            return;
        }
        int copyHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(copy);
        Formatter f = Formatter.of("hashCode: hashCodes should be equal:\n  %% (%%)\nand\n  %% (%%)", reference, referenceHashCode, copy, copyHashCode);
        Assert.assertEquals(f, referenceHashCode, copyHashCode);
    }

    private boolean isIdentical(T reference, T other) {
        return Rethrow.rethrow(() -> {
            for (FieldProbe probe : FieldIterable.of(reference.getClass())) {
                if (Objects.equals(probe.getValue(reference), probe.getValue(other))) continue;
                return false;
            }
            return true;
        });
    }

    private static final class SomethingElse {
        private SomethingElse() {
        }

        public int hashCode() {
            return Integer.MAX_VALUE;
        }
    }
}

