/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class BigDecimalFieldCheck<T>
implements FieldCheck<T> {
    public static final String ERROR_DOC_TITLE = "BigDecimal equality";
    private final SubjectCreator<T> subjectCreator;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public BigDecimalFieldCheck(SubjectCreator<T> subjectCreator, CachedHashCodeInitializer<T> cachedHashCodeInitializer) {
        this.subjectCreator = subjectCreator;
        this.cachedHashCodeInitializer = cachedHashCodeInitializer;
    }

    @Override
    public void execute(FieldProbe fieldProbe) {
        if (BigDecimal.class.equals(fieldProbe.getType())) {
            T left = this.subjectCreator.plain();
            BigDecimal referenceValue = (BigDecimal)fieldProbe.getValue(left);
            BigDecimal changedValue = referenceValue.setScale(referenceValue.scale() + 1, RoundingMode.UNNECESSARY);
            T right = this.subjectCreator.withFieldSetTo(fieldProbe.getField(), changedValue);
            this.checkEquals(fieldProbe.getField(), referenceValue, changedValue, left, right);
            this.checkHashCode(fieldProbe.getField(), referenceValue, changedValue, left, right);
        }
    }

    private void checkEquals(Field field, BigDecimal referenceValue, BigDecimal changedValue, T left, T right) {
        Formatter f = Formatter.of("BigDecimal equality: object does not equal a copy of itself where BigDecimal field %% has a value that is equal using compareTo: %% compared to %%\nIf these values should be considered equal then use compareTo rather than equals for this field.\nIf these values should not be considered equal, suppress Warning.%% to disable this check.", new Object[]{field.getName(), referenceValue, changedValue, Warning.BIGDECIMAL_EQUALITY});
        Assert.assertEquals(f, left, right);
    }

    private void checkHashCode(Field field, BigDecimal referenceValue, BigDecimal changedValue, T left, T right) {
        Formatter f = Formatter.of("BigDecimal equality: hashCode of object does not equal hashCode of a copy of itself where BigDecimal field %% has a value that is equal using compareTo: %% compared to %%\nIf these values should be considered equal then make sure to derive the same constituent hashCode from this field.\nIf these values should not be considered equal, suppress Warning.%% to disable this check.", new Object[]{field.getName(), referenceValue, changedValue, Warning.BIGDECIMAL_EQUALITY});
        int leftHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(left);
        int rightHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(right);
        Assert.assertEquals(f, leftHashCode, rightHashCode);
    }
}

