/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.util.Map;
import java.util.Objects;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class MapEntryHashCodeRequirementChecker<T>
implements Checker {
    private final Configuration<T> config;
    private final SubjectCreator<T> subjectCreator;

    public MapEntryHashCodeRequirementChecker(Context<T> context) {
        this.config = context.getConfiguration();
        this.subjectCreator = context.getSubjectCreator();
    }

    @Override
    public void check() {
        if (Map.Entry.class.isAssignableFrom(this.config.type())) {
            Map.Entry e = (Map.Entry)this.subjectCreator.plain();
            int expectedHashCode = Objects.hashCode(e.getKey()) ^ Objects.hashCode(e.getValue());
            int actualHashCode = this.config.cachedHashCodeInitializer().getInitializedHashCode(e);
            Formatter f = Formatter.of("Map.Entry: hashCode for\n  %%\nshould be %% but was %%.\nThe hash code of a map entry e is defined as:\n    (e.getKey()==null ? 0 : e.getKey().hashCode()) ^ (e.getValue()==null ? 0 : e.getValue().hashCode())\nor, using Java 8 API:\n    java.util.Objects.hashCode(e.getKey()) ^ java.util.Objects.hashCode(e.getValue())", e, expectedHashCode, actualHashCode);
            Assert.assertEquals(f, expectedHashCode, actualHashCode);
        }
    }
}

