/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.internal.instantiation.UserPrefabValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.instantiation.vintage.factories.Factories;
import nl.jqno.equalsverifier.internal.instantiation.vintage.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.instantiation.vintage.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.FieldCache;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.util.Validations;

public final class PrefabValuesApi {
    private PrefabValuesApi() {
    }

    public static <T> void addPrefabValues(UserPrefabValueProvider userPrefabs, Objenesis objenesis, Class<T> otherType, T red, T blue) {
        Validations.validateRedAndBluePrefabValues(otherType, red, blue);
        if (red.getClass().isArray()) {
            userPrefabs.register(otherType, red, blue, red);
        } else {
            try {
                T redCopy = ObjectAccessor.of(red).copy(objenesis);
                userPrefabs.register(otherType, red, blue, redCopy);
            }
            catch (InaccessibleObjectException ignored) {
                userPrefabs.register(otherType, red, blue, red);
            }
        }
    }

    public static <T> void addPrefabValuesForField(FieldCache fieldCache, Objenesis objenesis, Class<?> type, String fieldName, T red, T blue) {
        Validations.validateRedAndBluePrefabValues(fieldName, red, blue);
        Field f = Validations.validateFieldTypeMatches(type, fieldName, red.getClass());
        TypeTag tag = TypeTag.of(f, new TypeTag(type, new TypeTag[0]));
        if (red.getClass().isArray()) {
            fieldCache.put(f.getName(), tag, new Tuple<T>(red, blue, red));
        } else {
            try {
                T redCopy = ObjectAccessor.of(red).copy(objenesis);
                fieldCache.put(f.getName(), tag, new Tuple<T>(red, blue, redCopy));
            }
            catch (InaccessibleObjectException ignored) {
                fieldCache.put(f.getName(), tag, new Tuple<T>(red, blue, red));
            }
        }
    }

    public static <T> void addGenericPrefabValues(FactoryCache factoryCache, Class<T> otherType, Func.Func1<?, T> factory) {
        Validations.validateNotNull(factory, "factory is null.");
        PrefabValuesApi.addGenericPrefabValueFactory(factoryCache, otherType, Factories.simple(factory, null), 1);
    }

    public static <T> void addGenericPrefabValues(FactoryCache factoryCache, Class<T> otherType, Func.Func2<?, ?, T> factory) {
        Validations.validateNotNull(factory, "factory is null.");
        PrefabValuesApi.addGenericPrefabValueFactory(factoryCache, otherType, Factories.simple(factory, null), 2);
    }

    private static <T> void addGenericPrefabValueFactory(FactoryCache factoryCache, Class<T> otherType, PrefabValueFactory<T> factory, int arity) {
        Validations.validateGenericPrefabValues(otherType, factory, arity);
        factoryCache.put(otherType, factory);
    }
}

