/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.vintage.reflection;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import nl.jqno.equalsverifier.internal.instantiation.vintage.VintageValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.RecordProbe;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;

final class RecordObjectAccessor<T>
extends ObjectAccessor<T> {
    private final RecordProbe<T> probe;

    RecordObjectAccessor(T object, Class<T> type) {
        super(object, type);
        this.probe = new RecordProbe<T>(type);
    }

    @Override
    public T copy(Objenesis objenesis) {
        List<Object> params = this.probe.fields().map(this::getField).toList();
        return this.callRecordConstructor(params);
    }

    @Override
    public ObjectAccessor<T> scramble(VintageValueProvider valueProvider, TypeTag enclosingType, LinkedHashSet<TypeTag> typeStack) {
        return this.makeAccessor(fieldProbe -> {
            T value = this.getField((FieldProbe)fieldProbe);
            TypeTag tag = TypeTag.of(fieldProbe.getField(), enclosingType);
            return valueProvider.giveOther(tag, value, typeStack);
        });
    }

    private ObjectAccessor<T> makeAccessor(Function<FieldProbe, Object> determineValue) {
        List<Object> params = this.probe.fields().map(determineValue).toList();
        T newObject = this.callRecordConstructor(params);
        return ObjectAccessor.of(newObject);
    }

    private T callRecordConstructor(List<?> params) {
        RecordProbe p = new RecordProbe(this.type());
        return p.callRecordConstructor(params);
    }

    public T getField(FieldProbe fieldProbe) {
        return (T)fieldProbe.getValue(this.get());
    }
}

