/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.CheckReturnValue;
import nl.jqno.equalsverifier.EqualsVerifierReport;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.Mode;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.api.ConfiguredEqualsVerifier;
import nl.jqno.equalsverifier.api.EqualsVerifierApi;
import nl.jqno.equalsverifier.internal.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.util.ErrorMessage;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class MultipleTypeEqualsVerifierApi
implements EqualsVerifierApi<Void> {
    private final List<Class<?>> types;
    private final ConfiguredEqualsVerifier ev;

    public MultipleTypeEqualsVerifierApi(List<Class<?>> types, ConfiguredEqualsVerifier ev) {
        this.types = new ArrayList(types);
        this.ev = ev.copy();
    }

    @CheckReturnValue
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Set suppressions on ev, but return `this`")
    public MultipleTypeEqualsVerifierApi suppress(Warning ... warnings) {
        this.ev.suppress(warnings);
        return this;
    }

    @CheckReturnValue
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Set modes on ev, but return `this`")
    public MultipleTypeEqualsVerifierApi set(Mode ... modes) {
        this.ev.set(modes);
        return this;
    }

    @CheckReturnValue
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Set prefab values on ev, but return `this`")
    public <S> MultipleTypeEqualsVerifierApi withPrefabValues(Class<S> otherType, S red, S blue) {
        this.ev.withPrefabValues((Class)otherType, (Object)red, (Object)blue);
        return this;
    }

    @CheckReturnValue
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Set generic prefab values on ev, but return `this`")
    public <S> MultipleTypeEqualsVerifierApi withGenericPrefabValues(Class<S> otherType, Func.Func1<?, S> factory) {
        this.ev.withGenericPrefabValues((Class)otherType, (Func.Func1)factory);
        return this;
    }

    @CheckReturnValue
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Set generic prefab values on ev, but return `this`")
    public <S> MultipleTypeEqualsVerifierApi withGenericPrefabValues(Class<S> otherType, Func.Func2<?, ?, S> factory) {
        this.ev.withGenericPrefabValues((Class)otherType, (Func.Func2)factory);
        return this;
    }

    @CheckReturnValue
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Set usingGetClass on ev, but return `this`")
    public MultipleTypeEqualsVerifierApi usingGetClass() {
        this.ev.usingGetClass();
        return this;
    }

    @CheckReturnValue
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Set converters on ev, but return `this`")
    public MultipleTypeEqualsVerifierApi withFieldnameToGetterConverter(Function<String, String> converter) {
        this.ev.withFieldnameToGetterConverter((Function)converter);
        return this;
    }

    public void verify() {
        List failures = this.report().stream().filter(r -> !r.isSuccessful()).collect(Collectors.toList());
        if (failures.isEmpty()) {
            return;
        }
        String messages = Formatter.of("EqualsVerifier found a problem in %% %%.\n---\n%%\n---\n%%\n---\n%%", failures.size(), failures.size() == 1 ? "class" : "classes", failures.stream().map(r -> "* " + r.getType().getName()).collect(Collectors.joining("\n")), failures.stream().map(r -> r.getMessage()).collect(Collectors.joining("\n---\n")), ErrorMessage.suffix()).format();
        throw new AssertionError((Object)messages);
    }

    public List<EqualsVerifierReport> report() {
        return this.types.stream().map(t -> this.ev.forClass(t).report(false)).collect(Collectors.toList());
    }
}

