/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public final class ClassProbe<T> {
    private final Class<T> type;

    private ClassProbe(Class<T> type) {
        this.type = type;
    }

    public static <T> ClassProbe<T> of(Class<T> type) {
        return new ClassProbe<T>(type);
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isRecord() {
        return this.type.isRecord();
    }

    public boolean isSealed() {
        return this.type.isSealed();
    }

    public boolean declaresEquals() {
        return ClassProbe.declaresMethod(this.type, "equals", Object.class);
    }

    public boolean declaresHashCode() {
        return ClassProbe.declaresMethod(this.type, "hashCode", new Class[0]);
    }

    public boolean hasMethod(String name) {
        for (Class<T> t = this.type; t != null; t = t.getSuperclass()) {
            if (!ClassProbe.declaresMethod(t, name, new Class[0])) continue;
            return true;
        }
        return false;
    }

    private static boolean declaresMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            type.getDeclaredMethod(name, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isEqualsAbstract() {
        return this.isMethodAbstract("equals", Object.class);
    }

    public boolean isHashCodeAbstract() {
        return this.isMethodAbstract("hashCode", new Class[0]);
    }

    private boolean isMethodAbstract(String name, Class<?> ... parameterTypes) {
        return Rethrow.rethrow(() -> Modifier.isAbstract(this.type.getMethod(name, parameterTypes).getModifiers()));
    }

    public boolean isEqualsInheritedFromObject() {
        ClassProbe<T> i = this;
        while (i.getType() != Object.class) {
            if (i.declaresEquals() && !i.isEqualsAbstract()) {
                return false;
            }
            i = i.getSuperProbe();
        }
        return true;
    }

    public Optional<Field> findField(String name) {
        for (Class<T> t = this.type; t != null; t = t.getSuperclass()) {
            Field f = ClassProbe.getField(t, name);
            if (f == null) continue;
            return Optional.of(f);
        }
        return Optional.empty();
    }

    private static Field getField(Class<?> type, String name) {
        try {
            return type.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public ClassProbe<? super T> getSuperProbe() {
        return new ClassProbe<T>(this.type.getSuperclass());
    }
}

