/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.reflection.PackageScanOptions;
import nl.jqno.equalsverifier.internal.util.Rethrow;
import nl.jqno.equalsverifier.internal.util.Validations;

public final class PackageScanner {
    private PackageScanner() {
    }

    public static List<Class<?>> getClassesIn(String packageName, PackageScanOptions options) {
        List<Class<Class<?>>> result = PackageScanner.getDirs(packageName, options).stream().flatMap(d -> PackageScanner.getClassesInDir(packageName, d, options).stream()).collect(Collectors.toList());
        Validations.validateTypesAreKnown(options.exceptClasses(), result);
        result.removeAll(options.exceptClasses());
        result.removeIf(options.exclusionPredicate());
        return result;
    }

    private static List<File> getDirs(String packageName, PackageScanOptions options) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        return Rethrow.rethrow(() -> Collections.list(cl.getResources(path)).stream().flatMap(r -> PackageScanner.getResourcePath(r, options)).collect(Collectors.toList()), e -> "Could not scan package " + packageName);
    }

    private static Stream<File> getResourcePath(URL r, PackageScanOptions options) {
        String result = Rethrow.rethrow(() -> r.toURI().getPath(), e -> "Could not resolve resource path: " + e.getMessage());
        if (result == null) {
            if (options.ignoreExternalJars()) {
                return Stream.empty();
            }
            throw new ReflectionException("Could not resolve third-party resource " + String.valueOf(r));
        }
        return Stream.of(new File(result));
    }

    private static List<Class<?>> getClassesInDir(String packageName, File dir, PackageScanOptions options) {
        if (!dir.exists()) {
            return Collections.emptyList();
        }
        return Arrays.stream(dir.listFiles()).filter(f -> options.scanRecursively() && f.isDirectory() || f.getName().endsWith(".class")).flatMap(f -> {
            List<Class<?>> classes = f.isDirectory() ? PackageScanner.getClassesInDir(packageName + "." + f.getName(), f, options) : List.of(PackageScanner.fileToClass(packageName, f));
            return classes.stream();
        }).filter(c -> !c.isAnonymousClass()).filter(c -> !c.isLocalClass()).filter(c -> !c.getName().endsWith("Test")).filter(c -> options.mustExtend() == null || options.mustExtend().isAssignableFrom((Class<?>)c) && !options.mustExtend().equals(c)).collect(Collectors.toList());
    }

    private static Class<?> fileToClass(String packageName, File file) {
        String className = file.getName().substring(0, file.getName().length() - 6);
        return Rethrow.rethrow(() -> Class.forName(packageName + "." + className), e -> "Could not resolve class " + className + ", which was found in package " + packageName);
    }
}

