/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.Mode;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.annotations.Annotation;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCacheBuilder;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;

public final class Configuration<T> {
    private static final Function<String, String> DEFAULT_FIELDNAME_TO_GETTER_CONVERTER = fn -> "get" + Character.toUpperCase(fn.charAt(0)) + fn.substring(1);
    private final Class<T> type;
    private final Set<String> nonnullFields;
    private final Set<String> prefabbedFields;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;
    private final boolean hasRedefinedSuperclass;
    private final Class<? extends T> redefinedSubclass;
    private final boolean usingGetClass;
    private final EnumSet<Warning> warningsToSuppress;
    private final Set<Mode> modes;
    private final Function<String, String> fieldnameToGetter;
    private final boolean isKotlin;
    private final TypeTag typeTag;
    private final AnnotationCache annotationCache;
    private final Set<String> ignoredFields;
    private final List<T> equalExamples;
    private final List<T> unequalExamples;

    private Configuration(Class<T> type, TypeTag typeTag, Set<String> ignoredFields, Set<String> nonnullFields, Set<String> prefabbedFields, AnnotationCache annotationCache, CachedHashCodeInitializer<T> cachedHashCodeInitializer, boolean hasRedefinedSuperclass, Class<? extends T> redefinedSubclass, boolean usingGetClass, EnumSet<Warning> warningsToSuppress, Set<Mode> modes, Function<String, String> fieldnameToGetter, boolean isKotlin, List<T> equalExamples, List<T> unequalExamples) {
        this.type = type;
        this.typeTag = typeTag;
        this.ignoredFields = ignoredFields;
        this.nonnullFields = nonnullFields;
        this.prefabbedFields = prefabbedFields;
        this.annotationCache = annotationCache;
        this.cachedHashCodeInitializer = cachedHashCodeInitializer;
        this.hasRedefinedSuperclass = hasRedefinedSuperclass;
        this.redefinedSubclass = redefinedSubclass;
        this.usingGetClass = usingGetClass;
        this.warningsToSuppress = warningsToSuppress;
        this.modes = modes;
        this.fieldnameToGetter = fieldnameToGetter;
        this.isKotlin = isKotlin;
        this.equalExamples = equalExamples;
        this.unequalExamples = unequalExamples;
    }

    public static <T> Configuration<T> build(Class<T> type, Set<String> excludedFields, Set<String> includedFields, Set<String> nonnullFields, Set<String> prefabbedFields, CachedHashCodeInitializer<T> cachedHashCodeInitializer, boolean hasRedefinedSuperclass, Class<? extends T> redefinedSubclass, boolean usingGetClass, EnumSet<Warning> warningsToSuppress, Set<Mode> modes, Function<String, String> fieldnameToGetter, Set<String> ignoredAnnotationClassNames, Set<String> actualFields, List<T> equalExamples, List<T> unequalExamples) {
        TypeTag typeTag = new TypeTag(type, new TypeTag[0]);
        AnnotationCache annotationCache = Configuration.buildAnnotationCache(type, ignoredAnnotationClassNames);
        Set<String> ignoredFields = Configuration.determineIgnoredFields(type, annotationCache, warningsToSuppress, excludedFields, includedFields, actualFields);
        Function<String, String> converter = fieldnameToGetter != null ? fieldnameToGetter : DEFAULT_FIELDNAME_TO_GETTER_CONVERTER;
        boolean isKotlin = annotationCache.hasClassAnnotation(type, SupportedAnnotations.KOTLIN);
        return new Configuration<T>(type, typeTag, ignoredFields, nonnullFields, prefabbedFields, annotationCache, cachedHashCodeInitializer, hasRedefinedSuperclass, redefinedSubclass, usingGetClass, warningsToSuppress, modes, converter, isKotlin, equalExamples, unequalExamples);
    }

    private static <T> AnnotationCache buildAnnotationCache(Class<T> type, Set<String> ignoredAnnotationClassNames) {
        AnnotationCacheBuilder acb = new AnnotationCacheBuilder(SupportedAnnotations.values(), ignoredAnnotationClassNames);
        AnnotationCache cache = new AnnotationCache();
        acb.build(type, cache);
        return cache;
    }

    private static <T> Set<String> determineIgnoredFields(Class<T> type, AnnotationCache annotationCache, EnumSet<Warning> warningsToSuppress, Set<String> excludedFields, Set<String> includedFields, Set<String> actualFields) {
        BiFunction<String, Annotation, Boolean> fieldHas = (f, a) -> annotationCache.hasFieldAnnotation(type, (String)f, (Annotation)a);
        if (annotationCache.hasClassAnnotation(type, SupportedAnnotations.NATURALID)) {
            return actualFields.stream().filter(f -> (Boolean)fieldHas.apply((String)f, SupportedAnnotations.NATURALID) == false).collect(Collectors.toSet());
        }
        if (annotationCache.hasClassAnnotation(type, SupportedAnnotations.ID) && !warningsToSuppress.contains((Object)Warning.SURROGATE_OR_BUSINESS_KEY)) {
            if (warningsToSuppress.contains((Object)Warning.SURROGATE_KEY)) {
                return actualFields.stream().filter(f -> (Boolean)fieldHas.apply((String)f, SupportedAnnotations.ID) == false).collect(Collectors.toSet());
            }
            Set<String> ignored = actualFields.stream().filter(f -> (Boolean)fieldHas.apply((String)f, SupportedAnnotations.ID)).collect(Collectors.toSet());
            ignored.addAll(Configuration.determineAnnotationlessIgnoredFields(excludedFields, includedFields, actualFields));
            return ignored;
        }
        return Configuration.determineAnnotationlessIgnoredFields(excludedFields, includedFields, actualFields);
    }

    private static Set<String> determineAnnotationlessIgnoredFields(Set<String> excludedFields, Set<String> includedFields, Set<String> actualFields) {
        if (!includedFields.isEmpty()) {
            return actualFields.stream().filter(f -> !includedFields.contains(f)).collect(Collectors.toSet());
        }
        return excludedFields;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Set<String> getNonnullFields() {
        return Collections.unmodifiableSet(this.nonnullFields);
    }

    public Set<String> getPrefabbedFields() {
        return Collections.unmodifiableSet(this.prefabbedFields);
    }

    public CachedHashCodeInitializer<T> getCachedHashCodeInitializer() {
        return this.cachedHashCodeInitializer;
    }

    public boolean hasRedefinedSuperclass() {
        return this.hasRedefinedSuperclass;
    }

    public Class<? extends T> getRedefinedSubclass() {
        return this.redefinedSubclass;
    }

    public boolean isUsingGetClass() {
        return this.usingGetClass;
    }

    public EnumSet<Warning> getWarningsToSuppress() {
        return EnumSet.copyOf(this.warningsToSuppress);
    }

    public Set<Mode> getModes() {
        return Collections.unmodifiableSet(this.modes);
    }

    public Function<String, String> getFieldnameToGetter() {
        return this.fieldnameToGetter;
    }

    public boolean isKotlin() {
        return this.isKotlin;
    }

    public List<T> getEqualExamples() {
        return Collections.unmodifiableList(this.equalExamples);
    }

    public List<T> getUnequalExamples() {
        return Collections.unmodifiableList(this.unequalExamples);
    }

    public TypeTag getTypeTag() {
        return this.typeTag;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="A cache is inherently mutable.")
    public AnnotationCache getAnnotationCache() {
        return this.annotationCache;
    }

    public Set<String> getIgnoredFields() {
        return Collections.unmodifiableSet(this.ignoredFields);
    }
}

