/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.util.Set;
import nl.jqno.equalsverifier.Mode;
import nl.jqno.equalsverifier.internal.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.instantiation.CachingValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.ChainedValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.JavaApiPrefabValues;
import nl.jqno.equalsverifier.internal.instantiation.MockitoValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.instantiation.UserPrefabValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.prefab.BuiltinPrefabValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.instantiation.vintage.VintageValueProvider;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FieldCache;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.ExternalLibs;

public final class Context<T> {
    private final Class<T> type;
    private final Configuration<T> configuration;
    private final ClassProbe<T> classProbe;
    private final SubjectCreator<T> subjectCreator;
    private final ValueProvider valueProvider;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="FieldCache is inherently mutable")
    public Context(Configuration<T> configuration, UserPrefabValueProvider userPrefabs, FactoryCache factoryCache, FieldCache fieldCache, Objenesis objenesis) {
        this.type = configuration.getType();
        this.configuration = configuration;
        this.classProbe = ClassProbe.of(configuration.getType());
        Set<Mode> modes = configuration.getModes();
        BuiltinPrefabValueProvider builtinPrefabs = new BuiltinPrefabValueProvider();
        MockitoValueProvider mockito = new MockitoValueProvider(!ExternalLibs.isMockitoAvailable() || modes.contains(Mode.skipMockito()));
        ChainedValueProvider vintageChain = new ChainedValueProvider(userPrefabs, builtinPrefabs, mockito);
        FactoryCache cache = JavaApiPrefabValues.build().merge(factoryCache);
        VintageValueProvider vintage = new VintageValueProvider(vintageChain, cache, objenesis);
        ChainedValueProvider mainChain = new ChainedValueProvider(userPrefabs, builtinPrefabs, mockito, vintage);
        CachingValueProvider caching = new CachingValueProvider(fieldCache, mainChain);
        this.valueProvider = caching;
        this.subjectCreator = new SubjectCreator<T>(configuration, this.valueProvider, objenesis);
    }

    public Class<T> getType() {
        return this.type;
    }

    public Configuration<T> getConfiguration() {
        return this.configuration;
    }

    public ClassProbe<T> getClassProbe() {
        return this.classProbe;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="VintageValueProvider can use a mutable cache.")
    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public SubjectCreator<T> getSubjectCreator() {
        return this.subjectCreator;
    }
}

