/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.lang.reflect.InaccessibleObjectException;
import java.util.function.Function;
import nl.jqno.equalsverifier.internal.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;
import nl.jqno.equalsverifier.internal.exceptions.ModuleException;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;

public final class Rethrow {
    private Rethrow() {
    }

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"}, justification="In some cases we need to re-throw the original exception")
    public static <T> T rethrow(ThrowingSupplier<T> supplier, Function<Throwable, String> errorMessage) {
        try {
            return supplier.get();
        }
        catch (InaccessibleObjectException e) {
            throw new ModuleException("The class is not accessible via the Java Module system. Consider opening the module that contains it.", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionException(errorMessage.apply(e), e);
        }
        catch (Exception e) {
            throw new EqualsVerifierInternalBugException(errorMessage.apply(e), e);
        }
    }

    public static <T> T rethrow(ThrowingSupplier<T> supplier) {
        return Rethrow.rethrow(supplier, (Throwable e) -> e.getMessage());
    }

    public static void rethrow(ThrowingRunnable block, Function<Throwable, String> errorMessage) {
        Rethrow.rethrow(() -> {
            block.run();
            return null;
        }, errorMessage);
    }

    public static void rethrow(ThrowingRunnable block) {
        Rethrow.rethrow(block, (Throwable e) -> e.getMessage());
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"}, justification="In order to catch these exceptions in rethrow, the must be declared")
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"}, justification="In order to catch these exceptions in rethrow, the must be declared")
        public void run() throws Exception;
    }
}

