/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.prefab;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import nl.jqno.equalsverifier.internal.exceptions.NoValueException;
import nl.jqno.equalsverifier.internal.instantiation.prefab.ValueSupplier;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class JavaNetValueSupplier<T>
extends ValueSupplier<T> {
    public JavaNetValueSupplier(Class<T> type) {
        super(type);
    }

    @Override
    public Optional<Tuple<T>> get() {
        if (this.is(InetAddress.class)) {
            return this.wrap(InetAddress.class, () -> this.val(InetAddress.getLoopbackAddress(), InetAddress.getByName("127.0.0.42"), InetAddress.getLoopbackAddress()));
        }
        if (this.is(Inet4Address.class)) {
            return this.wrap(Inet4Address.class, () -> this.val(Inet4Address.getByName("127.0.0.1"), Inet4Address.getByName("127.0.0.42"), Inet4Address.getByName("127.0.0.1")));
        }
        if (this.is(Inet6Address.class)) {
            return this.wrap(Inet6Address.class, () -> this.val(Inet6Address.getByName("::1"), Inet6Address.getByName("::"), Inet6Address.getByName("::1")));
        }
        if (this.is(InetSocketAddress.class)) {
            return this.val(InetSocketAddress.createUnresolved("localhost", 8080), InetSocketAddress.createUnresolved("127.0.0.1", 8080), InetSocketAddress.createUnresolved("localhost", 8080));
        }
        if (this.is(URI.class)) {
            return this.val(URI.create("x"), URI.create("y"), URI.create("x"));
        }
        if (this.is(URL.class)) {
            return Rethrow.rethrow(() -> this.val(new URL("http://example.com"), new URL("http://localhost"), new URL("http://example.com")), e -> "Can't add prefab values for java.net.URL");
        }
        return Optional.empty();
    }

    private Optional<Tuple<T>> wrap(Class<?> type, Rethrow.ThrowingSupplier<Optional<Tuple<T>>> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new NoValueException("Could not construct a value for " + type.getSimpleName() + ": got " + e.getClass().getSimpleName() + ". Please add prefab values for this type.", e);
        }
    }
}

