/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.instantiation.Attributes;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class AbstractDelegationChecker<T>
implements Checker {
    private final Class<T> type;
    private final TypeTag typeTag;
    private final SubjectCreator<T> subjectCreator;
    private final ValueProvider valueProvider;
    private final ClassProbe<T> classProbe;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public AbstractDelegationChecker(Context<T> context) {
        Configuration<T> config = context.getConfiguration();
        this.type = context.getType();
        this.typeTag = config.typeTag();
        this.subjectCreator = context.getSubjectCreator();
        this.valueProvider = context.getValueProvider();
        this.classProbe = context.getClassProbe();
        this.cachedHashCodeInitializer = config.cachedHashCodeInitializer();
    }

    @Override
    public void check() {
        this.checkAbstractEqualsAndHashCode();
        this.checkAbstractDelegationInFields();
        T instance = this.subjectCreator.plain();
        T copy = this.subjectCreator.plain();
        this.checkAbstractDelegation(instance, copy);
    }

    private void checkAbstractEqualsAndHashCode() {
        boolean equalsIsAbstract = this.classProbe.isEqualsAbstract();
        boolean hashCodeIsAbstract = this.classProbe.isHashCodeAbstract();
        if (equalsIsAbstract && hashCodeIsAbstract) {
            Assert.fail(Formatter.of("Abstract delegation: %%'s equals and hashCode methods are both abstract. They should be concrete.", this.type.getSimpleName()));
        } else if (equalsIsAbstract) {
            Assert.fail(this.buildSingleAbstractMethodErrorMessage(this.type, true, true));
        } else if (hashCodeIsAbstract) {
            Assert.fail(this.buildSingleAbstractMethodErrorMessage(this.type, false, true));
        }
    }

    private void checkAbstractDelegationInFields() {
        for (FieldProbe probe : FieldIterable.of(this.type)) {
            TypeTag tag = TypeTag.of(probe.getField(), this.typeTag);
            Tuple tuple = this.safelyGetTuple(tag, probe.getName());
            if (tuple == null) continue;
            Object instance = tuple.red();
            Object copy = tuple.blue();
            this.checkAbstractMethods(tag.getType(), instance, copy, true);
        }
    }

    private <U> Tuple<U> safelyGetTuple(TypeTag tag, String fieldName) {
        try {
            return this.valueProvider.provideOrThrow(tag, Attributes.named(fieldName));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void checkAbstractDelegation(T instance, T copy) {
        this.checkAbstractMethods(this.type, instance, copy, false);
    }

    private Formatter buildSingleAbstractMethodErrorMessage(Class<?> c, boolean isEqualsAbstract, boolean bothShouldBeConcrete) {
        return Formatter.of("Abstract delegation: %%'s %% method is abstract, but %% is not.\n%%", c.getSimpleName(), isEqualsAbstract ? "equals" : "hashCode", isEqualsAbstract ? "hashCode" : "equals", bothShouldBeConcrete ? "Both should be concrete." : "Both should be either abstract or concrete.");
    }

    private <S> void checkAbstractMethods(Class<?> instanceClass, S instance, S copy, boolean prefabPossible) {
        Formatter f;
        try {
            instance.equals(copy);
        }
        catch (AbstractMethodError e) {
            f = this.buildAbstractDelegationErrorMessage(instanceClass, prefabPossible, "equals", e.getMessage());
            Assert.fail(f, e);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.cachedHashCodeInitializer.getInitializedHashCode(instance);
        }
        catch (AbstractMethodError e) {
            f = this.buildAbstractDelegationErrorMessage(instanceClass, prefabPossible, "hashCode", e.getMessage());
            Assert.fail(f, e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Formatter buildAbstractDelegationErrorMessage(Class<?> c, boolean prefabPossible, String method, String originalMessage) {
        String prefabbable = this.determinePrefabValueTypeForErrorMessage(prefabPossible, c.getName(), originalMessage);
        Formatter prefabFormatter = Formatter.of("\n\nAdd prefab values for %%.", prefabbable);
        return Formatter.of("Abstract delegation: %%'s %% method delegates to an abstract method:\n   %%%%", c.getSimpleName(), method, originalMessage, prefabbable != null ? prefabFormatter.format() : "");
    }

    private String determinePrefabValueTypeForErrorMessage(boolean prefabPossible, String className, String originalMessage) {
        String receiver;
        if (prefabPossible) {
            return className;
        }
        Matcher m = Pattern.compile("Receiver class .* ([^\\s]+)\\.$").matcher(originalMessage);
        if (m.find() && !className.equals(receiver = m.group(1))) {
            return receiver;
        }
        return null;
    }
}

