/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Set;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.instantiation.Attributes;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class ReflexivityFieldCheck<T>
implements FieldCheck<T> {
    private final TypeTag typeTag;
    private final SubjectCreator<T> subjectCreator;
    private final ValueProvider valueProvider;
    private final EnumSet<Warning> warningsToSuppress;
    private final Set<String> nonnullFields;
    private final Set<String> prefabbedFields;
    private final AnnotationCache annotationCache;

    public ReflexivityFieldCheck(Context<T> context) {
        this.subjectCreator = context.getSubjectCreator();
        this.valueProvider = context.getValueProvider();
        Configuration<T> config = context.getConfiguration();
        this.typeTag = config.typeTag();
        this.warningsToSuppress = config.warningsToSuppress();
        this.nonnullFields = config.nonnullFields();
        this.prefabbedFields = config.prefabbedFields();
        this.annotationCache = config.annotationCache();
    }

    @Override
    public void execute(FieldProbe fieldProbe) {
        if (this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY)) {
            return;
        }
        this.checkReferenceReflexivity();
        this.checkValueReflexivity(fieldProbe);
        this.checkNullReflexivity(fieldProbe);
    }

    private void checkReferenceReflexivity() {
        T left = this.subjectCreator.plain();
        T right = this.subjectCreator.plain();
        this.checkReflexivityFor(left, right);
    }

    private void checkValueReflexivity(FieldProbe probe) {
        Class<?> fieldType = probe.getType();
        if (this.warningsToSuppress.contains((Object)Warning.REFERENCE_EQUALITY)) {
            return;
        }
        if (fieldType.equals(Object.class) || fieldType.isInterface()) {
            return;
        }
        if (probe.isStatic()) {
            return;
        }
        ClassProbe<?> fieldTypeProbe = ClassProbe.of(fieldType);
        if (!fieldTypeProbe.declaresEquals()) {
            return;
        }
        if (fieldType.isSynthetic()) {
            return;
        }
        Field field = probe.getField();
        String fieldName = field.getName();
        TypeTag tag = TypeTag.of(field, this.typeTag);
        Tuple tuple = this.valueProvider.provideOrThrow(tag, Attributes.named(fieldName));
        T left = this.subjectCreator.withFieldSetTo(field, tuple.red());
        T right = this.subjectCreator.withFieldSetTo(field, tuple.redCopy());
        Formatter f = Formatter.of("Reflexivity: == used instead of .equals() on field: %%\nIf this is intentional, consider suppressing Warning.%%", probe.getDisplayName(), Warning.REFERENCE_EQUALITY.toString());
        Assert.assertEquals(f, left, right);
    }

    private void checkNullReflexivity(FieldProbe fieldProbe) {
        if (this.prefabbedFields.contains(fieldProbe.getName())) {
            return;
        }
        Field field = fieldProbe.getField();
        boolean nullWarningIsSuppressed = this.warningsToSuppress.contains((Object)Warning.NULL_FIELDS);
        boolean fieldIsNonNull = fieldProbe.isAnnotatedNonnull(this.annotationCache);
        boolean fieldIsMentionedExplicitly = this.nonnullFields.contains(field.getName());
        if (nullWarningIsSuppressed || fieldIsNonNull || fieldIsMentionedExplicitly) {
            return;
        }
        T left = this.subjectCreator.withFieldDefaulted(field);
        T right = this.subjectCreator.withFieldDefaulted(field);
        this.checkReflexivityFor(left, right);
    }

    private void checkReflexivityFor(T left, T right) {
        if (this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY)) {
            Formatter f = Formatter.of("Unnecessary suppression: %%. Two identical copies are equal.", Warning.IDENTICAL_COPY.toString());
            Assert.assertFalse(f, left.equals(right));
        } else {
            boolean isEntity = this.annotationCache.hasClassAnnotation(this.typeTag.getType(), SupportedAnnotations.ENTITY);
            if (isEntity) {
                Formatter f = Formatter.of("Reflexivity: entity does not equal an identical copy of itself:\n  %%\nIf this is intentional, consider suppressing Warning.%%.", left, Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY.toString());
                Assert.assertEquals(f, left, right);
            } else {
                Formatter f = Formatter.of("Reflexivity: object does not equal an identical copy of itself:\n  %%\nIf this is intentional, consider suppressing Warning.%%.", left, Warning.IDENTICAL_COPY.toString());
                Assert.assertEquals(f, left, right);
            }
        }
    }
}

