/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.util.Locale;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.instantiation.Attributes;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class StringFieldCheck<T>
implements FieldCheck<T> {
    public static final String ERROR_DOC_TITLE = "String equality";
    private final SubjectCreator<T> subjectCreator;
    private final ValueProvider valueProvider;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public StringFieldCheck(SubjectCreator<T> subjectCreator, ValueProvider instanceCreator, CachedHashCodeInitializer<T> cachedHashCodeInitializer) {
        this.subjectCreator = subjectCreator;
        this.valueProvider = instanceCreator;
        this.cachedHashCodeInitializer = cachedHashCodeInitializer;
    }

    @Override
    public void execute(FieldProbe fieldProbe) {
        if (String.class.equals(fieldProbe.getType()) && !fieldProbe.isStatic()) {
            boolean theirHashCodesAreEqual;
            T copy;
            T reference;
            TypeTag string = new TypeTag(String.class, new TypeTag[0]);
            String red = (String)this.valueProvider.provideOrThrow(string, Attributes.named(fieldProbe.getName())).red();
            try {
                reference = this.subjectCreator.withFieldSetTo(fieldProbe.getField(), red.toLowerCase(Locale.getDefault()));
                copy = this.subjectCreator.withFieldSetTo(fieldProbe.getField(), red.toUpperCase(Locale.getDefault()));
            }
            catch (ReflectionException ignored) {
                return;
            }
            boolean theyAreEqual = reference.equals(copy);
            boolean bl = theirHashCodesAreEqual = this.cachedHashCodeInitializer.getInitializedHashCode(reference) == this.cachedHashCodeInitializer.getInitializedHashCode(copy);
            if (theyAreEqual && !theirHashCodesAreEqual) {
                Assert.fail(Formatter.of("String equality: class uses equalsIgnoreCase to compare String field %%, but hashCode is case-sensitive. Use toUpperCase() to determine the hashCode.", fieldProbe.getDisplayName()));
            }
        }
    }
}

