/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.MethodDelegationBinder;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.ClassConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.MethodConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.TextConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodInvocation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.JavaConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.JavaType;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Origin {
    public boolean cache() default true;

    public boolean privileged() default false;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Origin>
    {
        INSTANCE;

        private static final MethodDescription.InDefinedShape CACHE;
        private static final MethodDescription.InDefinedShape PRIVILEGED;

        private static StackManipulation methodConstant(AnnotationDescription.Loadable<Origin> annotation, MethodDescription.InDefinedShape methodDescription) {
            MethodConstant.CanCache methodConstant = annotation.getValue(PRIVILEGED).resolve(Boolean.class) != false ? MethodConstant.ofPrivileged(methodDescription) : MethodConstant.of(methodDescription);
            return annotation.getValue(CACHE).resolve(Boolean.class) != false ? methodConstant.cached() : methodConstant;
        }

        @Override
        public Class<Origin> getHandledType() {
            return Origin.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Origin> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner, Assigner.Typing typing) {
            TypeDescription parameterType = target.getType().asErasure();
            if (parameterType.represents((Type)((Object)Class.class))) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(ClassConstant.of(implementationTarget.getOriginType().asErasure()));
            }
            if (parameterType.represents((Type)((Object)Method.class))) {
                return source.isMethod() ? new MethodDelegationBinder.ParameterBinding.Anonymous(Binder.methodConstant(annotation, (MethodDescription.InDefinedShape)source.asDefined())) : MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            if (parameterType.represents((Type)((Object)Constructor.class))) {
                return source.isConstructor() ? new MethodDelegationBinder.ParameterBinding.Anonymous(Binder.methodConstant(annotation, (MethodDescription.InDefinedShape)source.asDefined())) : MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            if (JavaType.EXECUTABLE.getTypeStub().equals(parameterType)) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(Binder.methodConstant(annotation, (MethodDescription.InDefinedShape)source.asDefined()));
            }
            if (parameterType.represents((Type)((Object)String.class))) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(new TextConstant(source.toString()));
            }
            if (parameterType.represents(Integer.TYPE)) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(IntegerConstant.forValue(source.getModifiers()));
            }
            if (parameterType.equals(JavaType.METHOD_HANDLE.getTypeStub())) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(JavaConstant.MethodHandle.of((MethodDescription.InDefinedShape)source.asDefined()).toStackManipulation());
            }
            if (parameterType.equals(JavaType.METHOD_TYPE.getTypeStub())) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(JavaConstant.MethodType.of((MethodDescription)source.asDefined()).toStackManipulation());
            }
            if (parameterType.equals(JavaType.METHOD_HANDLES_LOOKUP.getTypeStub())) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(MethodInvocation.lookup());
            }
            throw new IllegalStateException("The " + target + " method's " + target.getIndex() + " parameter is annotated with a Origin annotation with an argument not representing a Class, Method, Constructor, String, int, MethodType or MethodHandle type");
        }

        static {
            MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(Origin.class).getDeclaredMethods();
            CACHE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("cache"))).getOnly();
            PRIVILEGED = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("privileged"))).getOnly();
        }
    }
}

