/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.kotlin;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.kotlin.KotlinScreen;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Formatter;

public final class KotlinProbe {
    private KotlinProbe() {
    }

    public static List<String> translateKotlinToBytecodeFieldNames(Class<?> container, List<String> fieldNames) {
        return fieldNames.stream().map(fn -> KotlinProbe.translateKotlinToBytecodeFieldName(container, fn)).toList();
    }

    public static String translateKotlinToBytecodeFieldName(Class<?> container, String fieldName) {
        KClass kClass = JvmClassMappingKt.getKotlinClass(container);
        for (KProperty prop : KClasses.getMemberProperties((KClass)kClass)) {
            if (!prop.getName().equals(fieldName)) continue;
            Field backing = ReflectJvmMapping.getJavaField((KProperty)prop);
            return backing == null ? null : backing.getName();
        }
        return fieldName;
    }

    public static Optional<String> getKotlinPropertyNameFor(Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        KClass kClass = JvmClassMappingKt.getKotlinClass(declaringClass);
        for (KProperty prop : KClasses.getMemberProperties((KClass)kClass)) {
            Field backing = ReflectJvmMapping.getJavaField((KProperty)prop);
            if (backing == null || !backing.equals(field)) continue;
            return Optional.of(prop.getName());
        }
        return Optional.empty();
    }

    public static Optional<TypeTag> determineLazyType(Class<?> container, Field field) {
        KotlinProbe.assertHasKotlinReflect(field);
        if (!field.getType().equals(KotlinScreen.LAZY)) {
            return Optional.empty();
        }
        KClass kType = JvmClassMappingKt.getKotlinClass(container);
        Optional<String> optKFieldName = KotlinProbe.getKotlinPropertyNameFor(field);
        if (optKFieldName.isEmpty()) {
            return Optional.empty();
        }
        String kFieldName = optKFieldName.get();
        KCallable kField = kType.getMembers().stream().filter(m -> kFieldName.equals(m.getName())).findAny().get();
        KType kReturnType = kField.getReturnType();
        TypeTag tag = KotlinProbe.createTypeTag(kReturnType);
        return Optional.of(new TypeTag(KotlinScreen.LAZY, tag));
    }

    private static TypeTag createTypeTag(KType kType) {
        Class<?> rawClass = KotlinProbe.determineClass(kType);
        if (kType.getArguments().isEmpty()) {
            return new TypeTag(rawClass, new TypeTag[0]);
        }
        List<TypeTag> genericTypeTags = kType.getArguments().stream().map(a -> a.getType()).filter(Objects::nonNull).map(KotlinProbe::createTypeTag).collect(Collectors.toList());
        return new TypeTag(rawClass, genericTypeTags);
    }

    private static Class<?> determineClass(KType kType) {
        KClassifier classifier = kType.getClassifier();
        if (classifier instanceof KClass) {
            KClass kclass = (KClass)classifier;
            return JvmClassMappingKt.getJavaClass((KClass)kclass);
        }
        if (classifier instanceof KTypeParameter) {
            KTypeParameter kTypeParameter = (KTypeParameter)classifier;
            for (KType b : kTypeParameter.getUpperBounds()) {
                Class<?> upper = KotlinProbe.determineClass(b);
                if (Object.class.equals(upper)) continue;
                return upper;
            }
        }
        return Object.class;
    }

    private static void assertHasKotlinReflect(Field f) {
        if (!KotlinScreen.canProbe()) {
            String msg = "Cannot read Kotlin field " + f.getName() + ". Please add library org.jetbrains.kotlin:kotlin-reflect to your project so EqualsVerifier can analyse it.";
            Assert.fail(Formatter.of(msg, new Object[0]));
        }
    }
}

