/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.kotlin;

import java.lang.reflect.Field;
import nl.jqno.equalsverifier.internal.reflection.Util;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;

public final class KotlinScreen {
    public static final String GAV = "org.jetbrains.kotlin:kotlin-reflect";
    public static final String ERROR_MESSAGE = "Please add library org.jetbrains.kotlin:kotlin-reflect to your project so EqualsVerifier can analyse it.";
    public static final Class<?> LAZY = Util.classForName("kotlin.Lazy");
    private static final Object K_CLASSES = Util.classForName("kotlin.reflect.full.KClasses");

    private KotlinScreen() {
    }

    public static boolean canProbe() {
        return K_CLASSES != null;
    }

    public static boolean isKotlin(Class<?> type) {
        for (String name : SupportedAnnotations.KOTLIN.partialClassNames()) {
            Class annotation = Util.classForName(name);
            if (annotation == null || !type.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSyntheticKotlinDelegate(Field field) {
        return field.isSynthetic() && field.getName().startsWith("$$delegate_");
    }

    public static boolean isKotlinLazy(Field field) {
        return field.getType().getName().equals("kotlin.Lazy");
    }
}

