/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.util.Set;
import nl.jqno.equalsverifier.Mode;
import nl.jqno.equalsverifier.internal.instantiation.BuiltinGenericPrefabValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.BuiltinPrefabValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.BuiltinVersionSpecificValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.CachingValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.ChainedValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.MockitoValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.RecursionDetectingValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.instantiation.UserPrefabValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.instantiation.vintage.VintageValueProvider;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FieldCache;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.ExternalLibs;

public final class Context<T> {
    private final Class<T> type;
    private final Configuration<T> configuration;
    private final ClassProbe<T> classProbe;
    private final SubjectCreator<T> subjectCreator;
    private final ValueProvider valueProvider;

    public Context(Configuration<T> configuration, UserPrefabValueProvider userPrefabs, FactoryCache factoryCache, FieldCache fieldCache, Objenesis objenesis) {
        this.type = configuration.type();
        this.configuration = configuration;
        this.classProbe = ClassProbe.of(configuration.type());
        Set<Mode> modes = configuration.modes();
        RecursionDetectingValueProvider recursionDetector = new RecursionDetectingValueProvider();
        BuiltinPrefabValueProvider builtinPrefabs = new BuiltinPrefabValueProvider();
        BuiltinGenericPrefabValueProvider builtinGenericPrefabs = new BuiltinGenericPrefabValueProvider(recursionDetector);
        BuiltinVersionSpecificValueProvider versionSpecificBuiltinPrefabs = new BuiltinVersionSpecificValueProvider(recursionDetector);
        MockitoValueProvider mockito = new MockitoValueProvider(!ExternalLibs.isMockitoAvailable() || modes.contains(Mode.skipMockito()));
        RecursionDetectingValueProvider vintageRecursionDetector = new RecursionDetectingValueProvider();
        ChainedValueProvider vintageChain = new ChainedValueProvider(userPrefabs, builtinPrefabs, builtinGenericPrefabs, versionSpecificBuiltinPrefabs, mockito);
        vintageRecursionDetector.setValueProvider(vintageChain);
        VintageValueProvider vintage = new VintageValueProvider(vintageRecursionDetector, factoryCache, objenesis);
        ChainedValueProvider mainChain = new ChainedValueProvider(userPrefabs, builtinPrefabs, builtinGenericPrefabs, versionSpecificBuiltinPrefabs, mockito, vintage);
        CachingValueProvider caching = new CachingValueProvider(userPrefabs, fieldCache, mainChain);
        recursionDetector.setValueProvider(caching);
        this.valueProvider = caching;
        this.subjectCreator = new SubjectCreator<T>(configuration, recursionDetector, objenesis);
    }

    public Class<T> getType() {
        return this.type;
    }

    public Configuration<T> getConfiguration() {
        return this.configuration;
    }

    public ClassProbe<T> getClassProbe() {
        return this.classProbe;
    }

    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public SubjectCreator<T> getSubjectCreator() {
        return this.subjectCreator;
    }
}

