/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation;

import java.util.Optional;
import nl.jqno.equalsverifier.internal.instantiation.Attributes;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.prefab.GenericJavaLangValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.GenericJavaUtilConcurrentAtomicValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.GenericJavaUtilConcurrentValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.GenericJavaUtilValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.GenericOthersValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.GenericValueSupplier;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;

public class BuiltinGenericPrefabValueProvider
implements ValueProvider {
    private final ValueProvider vp;

    public BuiltinGenericPrefabValueProvider(ValueProvider vp) {
        this.vp = vp;
    }

    @Override
    public <T> Optional<Tuple<T>> provide(TypeTag tag, Attributes attributes) {
        Class type = tag.getType();
        GenericValueSupplier supplier = switch (type.getPackageName()) {
            case "java.lang" -> new GenericJavaLangValueSupplier(tag, this.vp, attributes);
            case "java.util" -> new GenericJavaUtilValueSupplier(tag, this.vp, attributes);
            case "java.util.concurrent" -> new GenericJavaUtilConcurrentValueSupplier(tag, this.vp, attributes);
            case "java.util.concurrent.atomic" -> new GenericJavaUtilConcurrentAtomicValueSupplier(tag, this.vp, attributes);
            default -> new GenericOthersValueSupplier(tag, this.vp, attributes);
        };
        return supplier.get();
    }
}

