/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation;

import java.util.Optional;
import nl.jqno.equalsverifier.internal.instantiation.Attributes;
import nl.jqno.equalsverifier.internal.instantiation.CacheDecider;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.reflection.FieldCache;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;

public class CachingValueProvider
implements ValueProvider {
    private final CacheDecider decider;
    private final FieldCache fieldCache;
    private final ValueProvider fallback;

    public CachingValueProvider(CacheDecider decider, FieldCache fieldCache, ValueProvider fallback) {
        this.decider = decider;
        this.fieldCache = fieldCache;
        this.fallback = fallback;
    }

    @Override
    public <T> Optional<Tuple<T>> provide(TypeTag tag, Attributes attributes) {
        String fieldName = attributes.fieldName();
        if (this.fieldCache.contains(fieldName, tag)) {
            return Optional.of(this.fieldCache.get(fieldName, tag));
        }
        Optional<Tuple<Tuple>> result = this.fallback.provide(tag, attributes);
        if (this.decider.canBeCached(tag.getType())) {
            result.ifPresent(tuple -> this.fieldCache.put(fieldName, tag, tuple));
        }
        return result;
    }
}

