/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation;

import java.util.Optional;
import nl.jqno.equalsverifier.internal.exceptions.MockitoException;
import nl.jqno.equalsverifier.internal.instantiation.Attributes;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import org.mockito.MockSettings;
import org.mockito.Mockito;

public class MockitoValueProvider
implements ValueProvider {
    private final boolean disable;

    public MockitoValueProvider(boolean disable) {
        this.disable = disable;
    }

    @Override
    public <T> Optional<Tuple<T>> provide(TypeTag tag, Attributes attributes) {
        if (this.disable) {
            return Optional.empty();
        }
        Class type = tag.getType();
        if (type.getPackageName().startsWith("java.")) {
            return Optional.empty();
        }
        if (type.isPrimitive() || type.isArray() || type.isEnum()) {
            return Optional.empty();
        }
        try {
            Object red = this.buildMock(type, attributes.fieldName(), "red");
            Object blue = this.buildMock(type, attributes.fieldName(), "blue");
            if (!red.equals(blue) && red.hashCode() != blue.hashCode()) {
                return Optional.of(new Tuple(red, blue, red));
            }
        }
        catch (RuntimeException ignored) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    private <T> T buildMock(Class<T> type, String fieldName, String color) {
        Object m = Mockito.mock(type, (MockSettings)Mockito.withSettings().defaultAnswer(invocation -> {
            throw new MockitoException(fieldName, type.getSimpleName(), invocation.getMethod().getName());
        }));
        Mockito.doReturn((Object)("[" + color + " mock for " + type.getSimpleName() + "]")).when(m).toString();
        return (T)m;
    }
}

