/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import nl.jqno.equalsverifier.internal.exceptions.ModuleException;
import nl.jqno.equalsverifier.internal.instantiation.Attributes;
import nl.jqno.equalsverifier.internal.instantiation.InstanceCreator;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class SubjectCreator<T> {
    private final TypeTag typeTag;
    private final Class<T> type;
    private final Class<? extends T> actualType;
    private final Configuration<T> config;
    private final ValueProvider valueProvider;
    private final ClassProbe<T> classProbe;
    private final Objenesis objenesis;
    private final InstanceCreator<T> instanceCreator;

    public SubjectCreator(Configuration<T> config, ValueProvider valueProvider, Objenesis objenesis) {
        this.typeTag = config.typeTag();
        this.type = this.typeTag.getType();
        this.config = config;
        this.valueProvider = valueProvider;
        this.classProbe = ClassProbe.of(this.type);
        this.objenesis = objenesis;
        this.instanceCreator = new InstanceCreator<T>(this.classProbe, objenesis);
        this.actualType = this.instanceCreator.getActualType();
    }

    public T plain() {
        return this.createInstance(this.empty());
    }

    public T withFieldDefaulted(Field field) {
        return this.createInstance(this.with(field, null));
    }

    public T withAllFieldsDefaulted() {
        Map<Field, Object> values = this.empty();
        for (FieldProbe p : this.fields()) {
            values.put(p.getField(), null);
        }
        return this.createInstance(values);
    }

    public T withAllMatchingFieldsDefaulted(Predicate<Field> predicate) {
        Map<Field, Object> values = this.empty();
        for (FieldProbe p : this.fields()) {
            if (!predicate.test(p.getField())) continue;
            values.put(p.getField(), null);
        }
        return this.createInstance(values);
    }

    public T withAllFieldsDefaultedExcept(Field field) {
        Map<Field, Object> values = this.empty();
        for (FieldProbe p : this.fields()) {
            Field f = p.getField();
            if (f.equals(field)) continue;
            values.put(f, null);
        }
        return this.createInstance(values);
    }

    public T withFieldSetTo(Field field, Object value) {
        return this.createInstance(this.with(field, value));
    }

    public T withFieldChanged(Field field) {
        if (FieldProbe.of(field).isStatic()) {
            return this.plain();
        }
        Object value = this.valuesFor(field).blue();
        return this.createInstance(this.with(field, value));
    }

    public T withAllFieldsChanged() {
        Map<Field, Object> values = this.empty();
        for (FieldProbe p : this.fields()) {
            Field f = p.getField();
            Object value = this.valuesFor(f).blue();
            values.put(f, value);
        }
        return this.createInstance(values);
    }

    public T withAllFieldsShallowlyChanged() {
        Map<Field, Object> values = this.empty();
        for (FieldProbe p : this.nonSuperFields()) {
            Field f = p.getField();
            Object value = this.valuesFor(f).blue();
            values.put(f, value);
        }
        return this.createInstance(values);
    }

    public Object copyIntoSuperclass(T original) {
        InstanceCreator<T> superCreator = new InstanceCreator<T>(ClassProbe.of(this.type.getSuperclass()), this.objenesis);
        return superCreator.copy(original);
    }

    public <S extends T> S copyIntoSubclass(T original, Class<S> subType) {
        InstanceCreator<S> subCreator = new InstanceCreator<S>(ClassProbe.of(subType), this.objenesis);
        return subCreator.copy(original);
    }

    private T createInstance(Map<Field, Object> givens) {
        Map<Field, Object> values = this.determineValues(givens);
        return (T)Rethrow.rethrow(() -> this.instanceCreator.instantiate(values));
    }

    private Map<Field, Object> determineValues(Map<Field, Object> givens) {
        HashMap<Field, Object> values = new HashMap<Field, Object>(givens);
        for (FieldProbe p : this.fields()) {
            boolean fieldCannotBeNull;
            Field f = p.getField();
            boolean fieldIsAbsent = !values.containsKey(f);
            boolean bl = fieldCannotBeNull = values.get(f) == null && !p.canBeDefault(this.config);
            if (!fieldIsAbsent && !fieldCannotBeNull) continue;
            Object value = this.valuesFor(f).red();
            values.put(f, value);
        }
        return values;
    }

    private Map<Field, Object> empty() {
        return new HashMap<Field, Object>();
    }

    private Map<Field, Object> with(Field f, Object v) {
        Map<Field, Object> result = this.empty();
        result.put(f, v);
        return result;
    }

    private FieldIterable fields() {
        return FieldIterable.ofIgnoringStatic(this.actualType);
    }

    private FieldIterable nonSuperFields() {
        return FieldIterable.ofIgnoringSuperAndStatic(this.type);
    }

    private Tuple<?> valuesFor(Field f) {
        String fieldName = f.getName();
        try {
            TypeTag fieldTag = TypeTag.of(f, this.typeTag);
            return this.valueProvider.provideOrThrow(fieldTag, Attributes.named(fieldName));
        }
        catch (ModuleException e) {
            throw new ModuleException("Field " + f.getName() + " of type " + f.getType().getName() + " is not accessible via the Java Module System.\nConsider opening the module that contains it, or add prefab values for type " + f.getType().getName() + ".", e);
        }
    }
}

