/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.prefab;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.internal.instantiation.Attributes;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;

public abstract class GenericValueSupplier<T> {
    private static final TypeTag OBJECT = new TypeTag(Object.class, new TypeTag[0]);
    protected final TypeTag tag;
    protected final ValueProvider vp;
    protected final Attributes attributes;

    public GenericValueSupplier(TypeTag tag, ValueProvider vp, Attributes attributes) {
        this.tag = tag;
        this.vp = vp;
        this.attributes = attributes;
    }

    public abstract Optional<Tuple<T>> get();

    protected boolean is(Class<?> otherType) {
        return this.tag.getType().equals(otherType);
    }

    protected <S> Optional<Tuple<T>> val(S red, S blue, S redCopy) {
        return Optional.of(new Tuple<S>(red, blue, redCopy));
    }

    protected Optional<Tuple<T>> generic(Func.Func1<Object, ?> construct) {
        Tuple<Object> tup = this.vp.provideOrThrow(this.determineGenericType(0), this.attributes.clearName()).map((T val) -> construct.supply(val));
        return Optional.of(tup);
    }

    protected Optional<Tuple<T>> generic(Func.Func1<Object, ?> construct, Supplier<?> empty) {
        Tuple<Object> tup = this.vp.provideOrThrow(this.determineGenericType(0), this.attributes.clearName()).map((T val) -> construct.supply(val)).swapBlueIfEqualToRed(() -> empty.get());
        return Optional.of(tup);
    }

    protected Optional<Tuple<T>> collection(Supplier<? extends Collection> construct) {
        Tuple<Object> tup = this.vp.provideOrThrow(this.determineGenericType(0), this.attributes.clearName()).map((T e) -> {
            Collection coll = (Collection)construct.get();
            coll.add(e);
            return coll;
        }).swapBlueIfEqualToRed(() -> construct.get());
        return Optional.of(tup);
    }

    protected Optional<Tuple<T>> map(Supplier<Map> construct) {
        Tuple<Object> keys = this.vp.provideOrThrow(this.determineGenericType(0), this.attributes.clearName());
        Tuple values = this.vp.provideOrThrow(this.determineGenericType(1), this.attributes.clearName());
        Tuple<Object> tup = keys.map((T e) -> {
            Map map = (Map)construct.get();
            map.put(e, values.blue());
            return map;
        }).swapBlueIfEqualToRed(() -> construct.get());
        return Optional.of(tup);
    }

    protected TypeTag determineGenericType(int index) {
        if (this.tag.genericTypes().size() <= index) {
            return OBJECT;
        }
        return this.tag.genericTypes().get(index);
    }
}

