/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.vintage.factories;

import java.lang.reflect.Array;
import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.instantiation.Attributes;
import nl.jqno.equalsverifier.internal.instantiation.vintage.VintageValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.instantiation.vintage.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;

public class FallbackFactory<T>
implements PrefabValueFactory<T> {
    private final Objenesis objenesis;

    public FallbackFactory(Objenesis objenesis) {
        this.objenesis = objenesis;
    }

    @Override
    public Tuple<T> createValues(TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack) {
        LinkedHashSet clone = (LinkedHashSet)typeStack.clone();
        clone.add(tag);
        Class type = tag.getType();
        if (type.isEnum()) {
            return this.giveEnumInstances(tag);
        }
        if (type.isArray()) {
            return this.giveArrayInstances(tag, valueProvider, clone);
        }
        return this.giveInstances(tag, valueProvider, clone);
    }

    private Tuple<T> giveEnumInstances(TypeTag tag) {
        Class type = tag.getType();
        T[] enumConstants = type.getEnumConstants();
        return switch (enumConstants.length) {
            case 0 -> new Tuple<Object>(null, null, null);
            case 1 -> new Tuple(enumConstants[0], enumConstants[0], enumConstants[0]);
            default -> new Tuple(enumConstants[0], enumConstants[1], enumConstants[0]);
        };
    }

    private Tuple<T> giveArrayInstances(TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack) {
        Class type = tag.getType();
        Class<?> componentType = type.getComponentType();
        TypeTag componentTag = new TypeTag(componentType, new TypeTag[0]);
        valueProvider.realizeCacheFor(componentTag, typeStack);
        Tuple tuple = valueProvider.provideOrThrow(componentTag, Attributes.empty());
        Object red = Array.newInstance(componentType, 1);
        Array.set(red, 0, tuple.red());
        Object blue = Array.newInstance(componentType, 2);
        Array.set(blue, 0, tuple.blue());
        Array.set(blue, 1, tuple.red());
        Object redCopy = Array.newInstance(componentType, 1);
        Array.set(redCopy, 0, tuple.red());
        return new Tuple<Object>(red, blue, redCopy);
    }

    private Tuple<T> giveInstances(TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack) {
        ClassAccessor accessor = ClassAccessor.of(tag.getType(), valueProvider, this.objenesis);
        Object red = accessor.getRedObject(tag, typeStack);
        Object blue = accessor.getBlueObject(tag, typeStack);
        Object redCopy = accessor.getRedObject(tag, typeStack);
        return new Tuple(red, blue, redCopy);
    }
}

