/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.description.module;

import java.lang.reflect.AnnotatedElement;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.build.AccessControllerPlugin;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.ModifierReviewable;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.NamedElement;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationSource;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ModuleVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.dispatcher.JavaDispatcher;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.nullability.AlwaysNull;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ModuleDescription
extends NamedElement,
ModifierReviewable.ForModuleDescription,
AnnotationSource {
    public static final String MODULE_CLASS_NAME = "module-info";
    @AlwaysNull
    public static final ModuleDescription UNDEFINED = null;

    public void accept(ClassVisitor var1);

    @MaybeNull
    public String getVersion();

    @MaybeNull
    public String getMainClass();

    public Set<String> getPackages();

    public Map<String, Exports> getExports();

    public Map<String, Opens> getOpens();

    public Map<String, Requires> getRequires();

    public Set<String> getUses();

    public Map<String, Provides> getProvides();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Latent
    extends AbstractBase {
        private final String name;
        private final int modifiers;
        @MaybeNull
        private final String version;
        @MaybeNull
        private final String mainClass;
        private final Set<String> packages;
        private final Map<String, Requires> requires;
        private final Map<String, Exports> exports;
        private final Map<String, Opens> opens;
        private final Set<String> uses;
        private final Map<String, Provides> provides;
        private final List<? extends AnnotationDescription> annotations;

        public Latent(String name, int modifiers, @MaybeNull String version, @MaybeNull String mainClass, Set<String> packages, Map<String, Requires> requires, Map<String, Exports> exports, Map<String, Opens> opens, Set<String> uses, Map<String, Provides> provides, List<? extends AnnotationDescription> annotations) {
            this.name = name;
            this.modifiers = modifiers;
            this.version = version;
            this.mainClass = mainClass;
            this.packages = packages;
            this.requires = requires;
            this.exports = exports;
            this.opens = opens;
            this.uses = uses;
            this.provides = provides;
            this.annotations = annotations;
        }

        @Override
        @MaybeNull
        public String getVersion() {
            return this.version;
        }

        @Override
        @MaybeNull
        public String getMainClass() {
            return this.mainClass;
        }

        @Override
        public Set<String> getPackages() {
            return this.packages;
        }

        @Override
        public Map<String, Exports> getExports() {
            return this.exports;
        }

        @Override
        public Map<String, Opens> getOpens() {
            return this.opens;
        }

        @Override
        public Map<String, Requires> getRequires() {
            return this.requires;
        }

        @Override
        public Set<String> getUses() {
            return this.uses;
        }

        @Override
        public Map<String, Provides> getProvides() {
            return this.provides;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public String getActualName() {
            return this.name;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoadedModule
    extends AbstractBase {
        protected static final Module MODULE;
        protected static final ModuleDescriptor MODULE_DESCRIPTOR;
        protected static final ModuleDescriptor.Exports MODULE_DESCRIPTOR_EXPORTS;
        protected static final ModuleDescriptor.Opens MODULE_DESCRIPTOR_OPENS;
        protected static final ModuleDescriptor.Requires MODULE_DESCRIPTOR_REQUIRES;
        protected static final ModuleDescriptor.Provides MODULE_DESCRIPTOR_PROVIDES;
        protected static final Optional OPTIONAL;
        private final AnnotatedElement module;
        private static final boolean ACCESS_CONTROLLER;

        public static ModuleDescription of(Object module) {
            if (!MODULE.isInstance(module)) {
                throw new IllegalArgumentException("Not a Java module: " + module);
            }
            if (!MODULE.isNamed(module)) {
                throw new IllegalArgumentException("Not a named module: " + module);
            }
            return new ForLoadedModule((AnnotatedElement)module);
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            PrivilegedAction<T> action;
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return action.run();
        }

        protected ForLoadedModule(AnnotatedElement module) {
            this.module = module;
        }

        @Override
        @MaybeNull
        public String getVersion() {
            return (String)OPTIONAL.orElse(MODULE_DESCRIPTOR.rawVersion(MODULE.getDescriptor(this.module)), null);
        }

        @Override
        @MaybeNull
        public String getMainClass() {
            return (String)OPTIONAL.orElse(MODULE_DESCRIPTOR.mainClass(MODULE.getDescriptor(this.module)), null);
        }

        @Override
        public boolean isOpen() {
            return MODULE_DESCRIPTOR.isOpen(MODULE.getDescriptor(this.module));
        }

        @Override
        public Set<String> getPackages() {
            return MODULE_DESCRIPTOR.packages(MODULE.getDescriptor(this.module));
        }

        @Override
        public Set<String> getUses() {
            return MODULE_DESCRIPTOR.uses(MODULE.getDescriptor(this.module));
        }

        @Override
        public Map<String, Exports> getExports() {
            LinkedHashMap<String, Exports> exports = new LinkedHashMap<String, Exports>();
            for (Object export : MODULE_DESCRIPTOR.exports(MODULE.getDescriptor(this.module))) {
                int modifiers = 0;
                for (Enum<?> modifier : MODULE_DESCRIPTOR_EXPORTS.modifiers(export)) {
                    String name = modifier.name();
                    if (name.equals("SYNTHETIC")) {
                        modifiers |= 0x1000;
                        continue;
                    }
                    if (name.equals("MANDATED")) {
                        modifiers |= 0x8000;
                        continue;
                    }
                    throw new IllegalStateException("Unknown export modifier: " + name);
                }
                exports.put(MODULE_DESCRIPTOR_EXPORTS.source(export), new Exports.Simple(MODULE_DESCRIPTOR_EXPORTS.targets(export), modifiers));
            }
            return exports;
        }

        @Override
        public Map<String, Opens> getOpens() {
            LinkedHashMap<String, Opens> opens = new LinkedHashMap<String, Opens>();
            for (Object open : MODULE_DESCRIPTOR.opens(MODULE.getDescriptor(this.module))) {
                int modifiers = 0;
                for (Enum<?> modifier : MODULE_DESCRIPTOR_OPENS.modifiers(open)) {
                    String name = modifier.name();
                    if (name.equals("SYNTHETIC")) {
                        modifiers |= 0x1000;
                        continue;
                    }
                    if (name.equals("MANDATED")) {
                        modifiers |= 0x8000;
                        continue;
                    }
                    throw new IllegalStateException("Unknown opens modifier: " + name);
                }
                opens.put(MODULE_DESCRIPTOR_OPENS.source(open), new Opens.Simple(MODULE_DESCRIPTOR_OPENS.targets(open), modifiers));
            }
            return opens;
        }

        @Override
        public Map<String, Requires> getRequires() {
            LinkedHashMap<String, Requires> requires = new LinkedHashMap<String, Requires>();
            for (Object require : MODULE_DESCRIPTOR.requires(MODULE.getDescriptor(this.module))) {
                int modifiers = 0;
                for (Enum<?> modifier : MODULE_DESCRIPTOR_REQUIRES.modifiers(require)) {
                    String name = modifier.name();
                    if (name.equals("SYNTHETIC")) {
                        modifiers |= 0x1000;
                        continue;
                    }
                    if (name.equals("MANDATED")) {
                        modifiers |= 0x8000;
                        continue;
                    }
                    if (name.equals("TRANSITIVE")) {
                        modifiers |= 0x20;
                        continue;
                    }
                    if (name.equals("STATIC")) {
                        modifiers |= 0x40;
                        continue;
                    }
                    throw new IllegalStateException("Unknown requires modifier: " + name);
                }
                requires.put(MODULE_DESCRIPTOR_REQUIRES.name(require), new Requires.Simple((String)OPTIONAL.orElse(MODULE_DESCRIPTOR_REQUIRES.rawCompiledVersion(require), null), modifiers));
            }
            return requires;
        }

        @Override
        public Map<String, Provides> getProvides() {
            LinkedHashMap<String, Provides> provides = new LinkedHashMap<String, Provides>();
            for (Object require : MODULE_DESCRIPTOR.provides(MODULE.getDescriptor(this.module))) {
                provides.put(MODULE_DESCRIPTOR_PROVIDES.service(require), new Provides.Simple(new LinkedHashSet<String>(MODULE_DESCRIPTOR_PROVIDES.providers(require))));
            }
            return provides;
        }

        @Override
        public int getModifiers() {
            int modifiers = 0;
            for (Enum<?> modifier : MODULE_DESCRIPTOR.modifiers(MODULE.getDescriptor(this.module))) {
                String name = modifier.name();
                if (name.equals("SYNTHETIC")) {
                    modifiers |= 0x1000;
                    continue;
                }
                if (name.equals("MANDATED")) {
                    modifiers |= 0x8000;
                    continue;
                }
                if (name.equals("OPEN")) {
                    modifiers |= 0x20;
                    continue;
                }
                throw new IllegalStateException("Unknown module modifier: " + name);
            }
            return modifiers;
        }

        @Override
        public String getActualName() {
            return MODULE_DESCRIPTOR.name(MODULE.getDescriptor(this.module));
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotations(this.module.getDeclaredAnnotations());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("nl.jqno.equalsverifier.internal.lib.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            MODULE = ForLoadedModule.doPrivileged(JavaDispatcher.of(Module.class));
            MODULE_DESCRIPTOR = ForLoadedModule.doPrivileged(JavaDispatcher.of(ModuleDescriptor.class));
            MODULE_DESCRIPTOR_EXPORTS = ForLoadedModule.doPrivileged(JavaDispatcher.of(ModuleDescriptor.Exports.class));
            MODULE_DESCRIPTOR_OPENS = ForLoadedModule.doPrivileged(JavaDispatcher.of(ModuleDescriptor.Opens.class));
            MODULE_DESCRIPTOR_REQUIRES = ForLoadedModule.doPrivileged(JavaDispatcher.of(ModuleDescriptor.Requires.class));
            MODULE_DESCRIPTOR_PROVIDES = ForLoadedModule.doPrivileged(JavaDispatcher.of(ModuleDescriptor.Provides.class));
            OPTIONAL = ForLoadedModule.doPrivileged(JavaDispatcher.of(Optional.class));
        }

        @JavaDispatcher.Proxied(value="java.util.Optional")
        protected static interface Optional {
            @MaybeNull
            @JavaDispatcher.Proxied(value="orElse")
            public Object orElse(Object var1, @MaybeNull Object var2);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @JavaDispatcher.Proxied(value="java.lang.module.ModuleDescriptor")
        protected static interface ModuleDescriptor {
            @JavaDispatcher.Proxied(value="name")
            public String name(Object var1);

            @JavaDispatcher.Proxied(value="modifiers")
            public Set<Enum<?>> modifiers(Object var1);

            @JavaDispatcher.Proxied(value="isOpen")
            public boolean isOpen(Object var1);

            @JavaDispatcher.Proxied(value="requires")
            public Set<?> requires(Object var1);

            @JavaDispatcher.Proxied(value="exports")
            public Set<?> exports(Object var1);

            @JavaDispatcher.Proxied(value="opens")
            public Set<?> opens(Object var1);

            @JavaDispatcher.Proxied(value="uses")
            public Set<String> uses(Object var1);

            @JavaDispatcher.Proxied(value="provides")
            public Set<?> provides(Object var1);

            @JavaDispatcher.Proxied(value="rawVersion")
            public Object rawVersion(Object var1);

            @JavaDispatcher.Proxied(value="mainClass")
            public Object mainClass(Object var1);

            @JavaDispatcher.Proxied(value="packages")
            public Set<String> packages(Object var1);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @JavaDispatcher.Proxied(value="java.lang.module.ModuleDescriptor$Provides")
            public static interface Provides {
                @JavaDispatcher.Proxied(value="service")
                public String service(Object var1);

                @JavaDispatcher.Proxied(value="providers")
                public List<String> providers(Object var1);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @JavaDispatcher.Proxied(value="java.lang.module.ModuleDescriptor$Opens")
            public static interface Opens {
                @JavaDispatcher.Proxied(value="source")
                public String source(Object var1);

                @JavaDispatcher.Proxied(value="modifiers")
                public Set<Enum<?>> modifiers(Object var1);

                @JavaDispatcher.Proxied(value="targets")
                public Set<String> targets(Object var1);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @JavaDispatcher.Proxied(value="java.lang.module.ModuleDescriptor$Exports")
            public static interface Exports {
                @JavaDispatcher.Proxied(value="source")
                public String source(Object var1);

                @JavaDispatcher.Proxied(value="modifiers")
                public Set<Enum<?>> modifiers(Object var1);

                @JavaDispatcher.Proxied(value="targets")
                public Set<String> targets(Object var1);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @JavaDispatcher.Proxied(value="java.lang.module.ModuleDescriptor$Requires")
            public static interface Requires {
                @JavaDispatcher.Proxied(value="name")
                public String name(Object var1);

                @JavaDispatcher.Proxied(value="modifiers")
                public Set<Enum<?>> modifiers(Object var1);

                @JavaDispatcher.Proxied(value="rawCompiledVersion")
                public Object rawCompiledVersion(Object var1);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @JavaDispatcher.Proxied(value="java.lang.Module")
        protected static interface Module {
            @JavaDispatcher.Instance
            @JavaDispatcher.Proxied(value="isInstance")
            public boolean isInstance(Object var1);

            @JavaDispatcher.Proxied(value="isNamed")
            public boolean isNamed(Object var1);

            @JavaDispatcher.Proxied(value="getName")
            public String getName(Object var1);

            @JavaDispatcher.Proxied(value="getPackages")
            public Set<String> getPackages(Object var1);

            @JavaDispatcher.Proxied(value="getDescriptor")
            public Object getDescriptor(Object var1);
        }
    }

    public static abstract class AbstractBase
    extends ModifierReviewable.AbstractBase
    implements ModuleDescription {
        public void accept(ClassVisitor classVisitor) {
            ModuleVisitor moduleVisitor = classVisitor.visitModule(this.getActualName(), this.getModifiers(), this.getVersion());
            if (moduleVisitor != null) {
                String mainClass = this.getMainClass();
                if (mainClass != null) {
                    moduleVisitor.visitMainClass(mainClass.replace('.', '/'));
                }
                for (String string : this.getPackages()) {
                    moduleVisitor.visitPackage(string.replace('.', '/'));
                }
                for (Map.Entry entry : this.getRequires().entrySet()) {
                    moduleVisitor.visitRequire((String)entry.getKey(), ((Requires)entry.getValue()).getModifiers(), ((Requires)entry.getValue()).getVersion());
                }
                for (Map.Entry entry : this.getExports().entrySet()) {
                    moduleVisitor.visitExport(((String)entry.getKey()).replace('.', '/'), ((Exports)entry.getValue()).getModifiers(), ((Exports)entry.getValue()).getTargets().isEmpty() ? null : ((Exports)entry.getValue()).getTargets().toArray(new String[0]));
                }
                for (Map.Entry entry : this.getOpens().entrySet()) {
                    moduleVisitor.visitOpen(((String)entry.getKey()).replace('.', '/'), ((Opens)entry.getValue()).getModifiers(), ((Opens)entry.getValue()).getTargets().isEmpty() ? null : ((Opens)entry.getValue()).getTargets().toArray(new String[0]));
                }
                for (String string : this.getUses()) {
                    moduleVisitor.visitUse(string.replace('.', '/'));
                }
                for (Map.Entry entry : this.getProvides().entrySet()) {
                    String[] provider;
                    String[] stringArray = provider = ((Provides)entry.getValue()).getProviders().isEmpty() ? null : new String[((Provides)entry.getValue()).getProviders().size()];
                    if (provider != null) {
                        Iterator<String> iterator = ((Provides)entry.getValue()).getProviders().iterator();
                        for (int index = 0; index < provider.length; ++index) {
                            provider[index] = iterator.next().replace('.', '/');
                        }
                    }
                    moduleVisitor.visitProvide(((String)entry.getKey()).replace('.', '/'), provider);
                }
                moduleVisitor.visitEnd();
            }
        }

        public int hashCode() {
            return 17 * this.getActualName().hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ModuleDescription)) {
                return false;
            }
            ModuleDescription module = (ModuleDescription)other;
            return this.getActualName().equals(module.getActualName());
        }

        public String toString() {
            return "module " + this.getActualName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Provides {
        public Set<String> getProviders();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Simple
        extends AbstractBase {
            private final Set<String> providers;

            public Simple(Set<String> providers) {
                this.providers = providers;
            }

            @Override
            public Set<String> getProviders() {
                return this.providers;
            }
        }

        public static abstract class AbstractBase
        implements Provides {
            public int hashCode() {
                return this.getProviders().hashCode();
            }

            public boolean equals(Object other) {
                if (!(other instanceof Provides)) {
                    return false;
                }
                Provides provides = (Provides)other;
                return this.getProviders().equals(provides.getProviders());
            }

            public String toString() {
                return "Provides{providers=" + this.getProviders() + '}';
            }
        }
    }

    public static interface Requires
    extends ModifierReviewable.ForModuleRequirement {
        @MaybeNull
        public String getVersion();

        public static class Simple
        extends AbstractBase {
            @MaybeNull
            private final String version;
            private final int modifiers;

            public Simple(@MaybeNull String version, int modifiers) {
                this.version = version;
                this.modifiers = modifiers;
            }

            @MaybeNull
            public String getVersion() {
                return this.version;
            }

            public int getModifiers() {
                return this.modifiers;
            }
        }

        public static abstract class AbstractBase
        extends ModifierReviewable.AbstractBase
        implements Requires {
            public int hashCode() {
                int hashCode = this.getModifiers();
                String version = this.getVersion();
                return version == null ? hashCode : hashCode + 17 * version.hashCode();
            }

            public boolean equals(Object other) {
                if (!(other instanceof Requires)) {
                    return false;
                }
                Requires requires = (Requires)other;
                String version = this.getVersion();
                return this.getModifiers() == requires.getModifiers() && version == null ? requires.getVersion() == null : version.equals(requires.getVersion());
            }

            public String toString() {
                String version = this.getVersion();
                return "Requires{version=" + (version == null ? "" : '\"' + version + '\'') + ",modifiers=" + this.getModifiers() + '}';
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Opens
    extends ModifierReviewable.OfMandatable {
        public Set<String> getTargets();

        public boolean isQualified();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Simple
        extends AbstractBase {
            private final Set<String> targets;
            protected final int modifiers;

            public Simple(Set<String> targets, int modifiers) {
                this.targets = targets;
                this.modifiers = modifiers;
            }

            @Override
            public Set<String> getTargets() {
                return this.targets;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }
        }

        public static abstract class AbstractBase
        extends ModifierReviewable.AbstractBase
        implements Opens {
            public boolean isQualified() {
                return !this.getTargets().isEmpty();
            }

            public int hashCode() {
                int hashCode = this.getModifiers();
                return hashCode + 17 * this.getTargets().hashCode();
            }

            public boolean equals(Object other) {
                if (!(other instanceof Opens)) {
                    return false;
                }
                Opens opens = (Opens)other;
                return this.getModifiers() == opens.getModifiers() && this.getTargets().equals(opens.getTargets());
            }

            public String toString() {
                return "Opens{targets=" + this.getTargets() + ",modifiers=" + this.getModifiers() + '}';
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Exports
    extends ModifierReviewable.OfMandatable {
        public Set<String> getTargets();

        public boolean isQualified();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Simple
        extends AbstractBase {
            private final Set<String> targets;
            protected final int modifiers;

            public Simple(Set<String> targets, int modifiers) {
                this.targets = targets;
                this.modifiers = modifiers;
            }

            @Override
            public Set<String> getTargets() {
                return this.targets;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }
        }

        public static abstract class AbstractBase
        extends ModifierReviewable.AbstractBase
        implements Exports {
            public boolean isQualified() {
                return !this.getTargets().isEmpty();
            }

            public int hashCode() {
                int hashCode = this.getModifiers();
                return hashCode + 17 * this.getTargets().hashCode();
            }

            public boolean equals(Object other) {
                if (!(other instanceof Exports)) {
                    return false;
                }
                Exports exports = (Exports)other;
                return this.getModifiers() == exports.getModifiers() && this.getTargets().equals(exports.getTargets());
            }

            public String toString() {
                return "Opens{targets=" + this.getTargets() + ",modifiers=" + this.getModifiers() + '}';
            }
        }
    }
}

