/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.util.Optional;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;

public final class SealedTypesFinder {
    private SealedTypesFinder() {
    }

    public static <T, U extends T> Optional<Class<U>> findInstantiableSubclass(ClassProbe<T> probe) {
        return SealedTypesFinder.findInstantiablePermittedClass(probe);
    }

    private static <T, U extends T> Optional<Class<U>> findInstantiablePermittedClass(ClassProbe<T> probe) {
        if (!probe.isAbstract() || !probe.isSealed()) {
            Class<T> result = probe.getType();
            return Optional.of(result);
        }
        Class<?>[] permittedSubclasses = probe.getType().getPermittedSubclasses();
        if (permittedSubclasses == null) {
            return Optional.empty();
        }
        for (Class<?> permitted : permittedSubclasses) {
            Class<?> subType = permitted;
            ClassProbe<?> subProbe = ClassProbe.of(subType);
            Optional<Class<U>> c = SealedTypesFinder.findInstantiablePermittedClass(subProbe);
            if (!c.isPresent()) continue;
            return c;
        }
        throw new EqualsVerifierInternalBugException("Could not find a non-sealed subtype for " + probe.getType().getCanonicalName());
    }
}

