/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Function;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.ExceptionMethod;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.Instantiator;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class JpaLazyGetterFieldCheck<T>
implements FieldCheck<T> {
    private final SubjectCreator<T> subjectCreator;
    private final Class<T> type;
    private final ClassProbe<T> classProbe;
    private final AnnotationCache annotationCache;
    private final Function<String, String> fieldnameToGetter;
    private final boolean strictHashcode;

    public JpaLazyGetterFieldCheck(Context<T> context) {
        this.subjectCreator = context.getSubjectCreator();
        this.type = context.getType();
        this.classProbe = context.getClassProbe();
        Configuration<T> config = context.getConfiguration();
        this.annotationCache = config.annotationCache();
        this.fieldnameToGetter = config.fieldnameToGetter();
        this.strictHashcode = config.warningsToSuppress().contains((Object)Warning.STRICT_HASHCODE);
    }

    @Override
    public void execute(FieldProbe fieldProbe) {
        String fieldName = fieldProbe.getName();
        String fieldDisplayName = fieldProbe.getDisplayName();
        String getterName = this.fieldnameToGetter.apply(fieldName);
        if (!this.fieldIsUsed(fieldProbe.getField(), true) || !this.fieldIsLazy(fieldName) || Modifier.isFinal(this.type.getModifiers())) {
            return;
        }
        Assert.assertTrue(Formatter.of("Class %% doesn't contain getter %%() for field %%.", this.classProbe.getType().getSimpleName(), getterName, fieldDisplayName), this.classProbe.hasMethod(getterName));
        Assert.assertFalse(Formatter.of("Getter method %% in JPA entity class %% is final.\n   EqualsVerifier cannot determine if %% calls getters instead of referencing field %% directly.\n   Please make the method non-final, or suppress Warning.JPA_GETTER to disable the check.", getterName, this.classProbe.getType().getSimpleName(), this.classProbe.getType().getSimpleName(), fieldDisplayName), this.classProbe.isMethodFinal(getterName, new Class[0]));
        Class<T> sub = this.throwingGetterCreator(getterName);
        T original = this.subjectCreator.plain();
        T red1 = this.subjectCreator.copyIntoSubclass(original, sub);
        T red2 = this.subjectCreator.copyIntoSubclass(original, sub);
        boolean equalsExceptionCaught = false;
        try {
            red1.equals(red2);
        }
        catch (EqualsVerifierInternalBugException e) {
            equalsExceptionCaught = true;
        }
        this.assertEntity(fieldDisplayName, "equals", getterName, equalsExceptionCaught);
        boolean usedInHashcode = !this.strictHashcode || this.fieldIsUsed(fieldProbe.getField(), false);
        boolean hashCodeExceptionCaught = false;
        try {
            red1.hashCode();
        }
        catch (EqualsVerifierInternalBugException e) {
            hashCodeExceptionCaught = true;
        }
        this.assertEntity(fieldDisplayName, "hashCode", getterName, hashCodeExceptionCaught || !usedInHashcode);
    }

    private boolean fieldIsUsed(Field field, boolean forEquals) {
        T red = this.subjectCreator.plain();
        T blue = this.subjectCreator.withFieldChanged(field);
        if (forEquals) {
            return !red.equals(blue);
        }
        return red.hashCode() != blue.hashCode();
    }

    private boolean fieldIsLazy(String fieldName) {
        return this.annotationCache.hasFieldAnnotation(this.type, fieldName, SupportedAnnotations.JPA_LINKED_FIELD) || this.annotationCache.hasFieldAnnotation(this.type, fieldName, SupportedAnnotations.JPA_LAZY_FIELD);
    }

    private Class<T> throwingGetterCreator(String getterName) {
        return Instantiator.giveDynamicSubclass(this.type, getterName, builder -> builder.method(ElementMatchers.named(getterName)).intercept(ExceptionMethod.throwing(EqualsVerifierInternalBugException.class)));
    }

    private void assertEntity(String fieldDisplayName, String method, String getterName, boolean assertion) {
        Assert.assertTrue(Formatter.of("JPA Entity: direct reference to field %% used in %% instead of getter %%().", fieldDisplayName, method, getterName), assertion);
    }
}

