/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.instantiation.vintage.factories.EnumMapFactory;
import nl.jqno.equalsverifier.internal.instantiation.vintage.factories.EnumSetFactory;
import nl.jqno.equalsverifier.internal.instantiation.vintage.factories.Factories;
import nl.jqno.equalsverifier.internal.instantiation.vintage.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.kotlin.KotlinLazy;
import nl.jqno.equalsverifier.internal.reflection.kotlin.KotlinScreen;
import nl.jqno.equalsverifier.internal.versionspecific.ScopedValuesHelper;
import nl.jqno.equalsverifier.internal.versionspecific.SequencedCollectionsHelper;

public final class JavaApiPrefabValues {
    private static final Comparator<Object> OBJECT_COMPARATOR = Comparator.comparingInt(Object::hashCode);
    private final FactoryCache factoryCache;

    private JavaApiPrefabValues(FactoryCache factoryCache) {
        this.factoryCache = factoryCache;
    }

    public static FactoryCache build() {
        FactoryCache result = new FactoryCache();
        new JavaApiPrefabValues(result).addJavaClasses();
        return result;
    }

    private void addJavaClasses() {
        this.addNonCollectionClasses();
        this.addCollection();
        this.addLists();
        this.addMaps();
        this.addSets();
        this.addQueues();
        SequencedCollectionsHelper.add(this.factoryCache);
        ScopedValuesHelper.add(this.factoryCache);
        this.addAtomicClasses();
        this.addKotlinClasses();
    }

    private void addNonCollectionClasses() {
        this.addFactory(CompletableFuture.class, Factories.simple(ignored -> new CompletableFuture(), CompletableFuture::new));
        this.addFactory(Optional.class, Factories.simple(Optional::of, Optional::empty));
        this.addFactory(Supplier.class, Factories.simple(a -> () -> a, () -> () -> null));
        this.addFactory(ThreadLocal.class, Factories.simple(a -> ThreadLocal.withInitial(() -> a), null));
    }

    private void addCollection() {
        this.addFactory(Iterable.class, Factories.simple(a -> List.of(a), ArrayList::new));
        this.addFactory(Collection.class, Factories.collection(ArrayList::new));
    }

    private void addLists() {
        this.addFactory(List.class, Factories.collection(ArrayList::new));
        this.addFactory(CopyOnWriteArrayList.class, Factories.collection(CopyOnWriteArrayList::new));
        this.addFactory(LinkedList.class, Factories.collection(LinkedList::new));
        this.addFactory(ArrayList.class, Factories.collection(ArrayList::new));
        this.addFactory(Vector.class, Factories.collection(Vector::new));
        this.addFactory(Stack.class, Factories.collection(Stack::new));
    }

    private void addMaps() {
        this.addFactory(Map.class, Factories.map(HashMap::new));
        this.addFactory(SortedMap.class, Factories.map(() -> new TreeMap(OBJECT_COMPARATOR)));
        this.addFactory(NavigableMap.class, Factories.map(() -> new TreeMap(OBJECT_COMPARATOR)));
        this.addFactory(ConcurrentNavigableMap.class, Factories.map(() -> new ConcurrentSkipListMap(OBJECT_COMPARATOR)));
        this.addFactory(ConcurrentHashMap.class, Factories.map(ConcurrentHashMap::new));
        this.addFactory(HashMap.class, Factories.map(HashMap::new));
        this.addFactory(Hashtable.class, Factories.map(Hashtable::new));
        this.addFactory(LinkedHashMap.class, Factories.map(LinkedHashMap::new));
        this.addFactory(Properties.class, Factories.map(Properties::new));
        this.addFactory(TreeMap.class, Factories.map(() -> new TreeMap(OBJECT_COMPARATOR)));
        this.addFactory(WeakHashMap.class, Factories.map(WeakHashMap::new));
        this.addFactory(EnumMap.class, new EnumMapFactory<EnumMap>(EnumMap::new));
    }

    private void addSets() {
        this.addFactory(Set.class, Factories.collection(HashSet::new));
        this.addFactory(SortedSet.class, Factories.collection(() -> new TreeSet<Object>(OBJECT_COMPARATOR)));
        this.addFactory(NavigableSet.class, Factories.collection(() -> new TreeSet<Object>(OBJECT_COMPARATOR)));
        this.addFactory(CopyOnWriteArraySet.class, Factories.collection(CopyOnWriteArraySet::new));
        this.addFactory(HashSet.class, Factories.collection(HashSet::new));
        this.addFactory(TreeSet.class, Factories.collection(() -> new TreeSet<Object>(OBJECT_COMPARATOR)));
        this.addFactory(EnumSet.class, new EnumSetFactory<EnumSet>(c -> EnumSet.copyOf(c)));
    }

    private void addQueues() {
        this.addFactory(Queue.class, Factories.collection(() -> new ArrayBlockingQueue(1)));
        this.addFactory(BlockingQueue.class, Factories.collection(() -> new ArrayBlockingQueue(1)));
        this.addFactory(Deque.class, Factories.collection(() -> new ArrayDeque(1)));
        this.addFactory(BlockingDeque.class, Factories.collection(() -> new LinkedBlockingDeque(1)));
        this.addFactory(ArrayBlockingQueue.class, Factories.collection(() -> new ArrayBlockingQueue(1)));
        this.addFactory(ConcurrentLinkedQueue.class, Factories.collection(ConcurrentLinkedQueue::new));
        this.addFactory(DelayQueue.class, Factories.collection(DelayQueue::new));
        this.addFactory(LinkedBlockingQueue.class, Factories.collection(() -> new LinkedBlockingQueue(1)));
        this.addFactory(PriorityBlockingQueue.class, Factories.collection(() -> new PriorityBlockingQueue<Object>(1, OBJECT_COMPARATOR)));
    }

    private void addAtomicClasses() {
        this.addFactory(AtomicMarkableReference.class, Factories.simple(r -> new AtomicMarkableReference<Object>(r, true), null));
        this.addFactory(AtomicReference.class, Factories.simple(AtomicReference::new, null));
        this.addFactory(AtomicStampedReference.class, Factories.simple(r -> new AtomicStampedReference<Object>(r, 0), null));
        this.addFactory(AtomicReferenceArray.class, (tag, pv, stack) -> {
            TypeTag genericTag = tag.genericTypes().get(0);
            Object[] red = new Object[]{pv.giveRed(genericTag)};
            Object[] blue = new Object[]{pv.giveBlue(genericTag)};
            Object[] redCopy = new Object[]{pv.giveRedCopy(genericTag)};
            return new Tuple<AtomicReferenceArray<Object>>(new AtomicReferenceArray<Object>(red), new AtomicReferenceArray<Object>(blue), new AtomicReferenceArray<Object>(redCopy));
        });
    }

    private void addKotlinClasses() {
        if (KotlinScreen.LAZY != null) {
            this.addFactory(KotlinScreen.LAZY, (tag, pv, stack) -> {
                TypeTag genericTag = tag.genericTypes().get(0);
                return new Tuple(KotlinLazy.lazy(pv.giveRed(genericTag)), KotlinLazy.lazy(pv.giveBlue(genericTag)), KotlinLazy.lazy(pv.giveRedCopy(genericTag)));
            });
        }
    }

    private <T> void addFactory(Class<T> type, PrefabValueFactory<T> factory) {
        this.factoryCache.put(type, factory);
    }
}

