/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.prefab;

import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaAwtValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaIoValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaLangReflectValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaLangValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaMathValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaNetValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaNioValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaRmiValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaSqlValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaTextValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaTimeValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaUtilConcurrentValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaUtilValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaxNamingValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.JavaxSwingValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.OthersValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.PrimitiveValueSupplier;
import nl.jqno.equalsverifier.internal.instantiation.prefab.ValueSupplier;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;

public class BuiltinPrefabValueProvider
implements ValueProvider {
    private static final Set<Class<?>> EXCEPTIONAL_GENERIC_TYPES = Set.of(Class.class, Constructor.class, SynchronousQueue.class, Enum.class);

    @Override
    public <T> Optional<Tuple<T>> provide(TypeTag tag, String fieldName) {
        Class type = tag.getType();
        if (!tag.genericTypes().isEmpty() && !EXCEPTIONAL_GENERIC_TYPES.contains(type)) {
            return Optional.empty();
        }
        if (PrimitiveMappers.DEFAULT_WRAPPED_VALUE_MAPPER.containsKey(type)) {
            return new PrimitiveValueSupplier(type).get();
        }
        ValueSupplier supplier = switch (type.getPackageName()) {
            case "java.awt" -> new JavaAwtValueSupplier(type);
            case "java.awt.color" -> new JavaAwtValueSupplier(type);
            case "java.io" -> new JavaIoValueSupplier(type);
            case "java.lang" -> new JavaLangValueSupplier(type);
            case "java.lang.reflect" -> new JavaLangReflectValueSupplier(type);
            case "java.math" -> new JavaMathValueSupplier(type);
            case "java.net" -> new JavaNetValueSupplier(type);
            case "java.nio" -> new JavaNioValueSupplier(type);
            case "java.nio.charset" -> new JavaNioValueSupplier(type);
            case "java.rmi.dgc" -> new JavaRmiValueSupplier(type);
            case "java.rmi.server" -> new JavaRmiValueSupplier(type);
            case "java.sql" -> new JavaSqlValueSupplier(type);
            case "java.text" -> new JavaTextValueSupplier(type);
            case "java.time" -> new JavaTimeValueSupplier(type);
            case "java.util" -> new JavaUtilValueSupplier(type);
            case "java.util.concurrent" -> new JavaUtilConcurrentValueSupplier(type);
            case "java.util.concurrent.atomic" -> new JavaUtilConcurrentValueSupplier(type);
            case "java.util.concurrent.locks" -> new JavaUtilConcurrentValueSupplier(type);
            case "javax.naming" -> new JavaxNamingValueSupplier(type);
            case "javax.swing.tree" -> new JavaxSwingValueSupplier(type);
            default -> new OthersValueSupplier(type);
        };
        return supplier.get();
    }
}

