/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;
import nl.jqno.equalsverifier.internal.reflection.Util;
import nl.jqno.equalsverifier.internal.reflection.kotlin.KotlinProbe;
import nl.jqno.equalsverifier.internal.reflection.kotlin.KotlinScreen;

public record TypeTag(Class<?> type, List<TypeTag> genericTypes) {
    public static final TypeTag NULL = new TypeTag(NullType.class, new TypeTag[0]);

    public TypeTag(Class<?> type, TypeTag ... genericTypes) {
        this(type, Arrays.asList(genericTypes));
    }

    public TypeTag(Class<?> type, List<TypeTag> genericTypes) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
        this.genericTypes = Collections.unmodifiableList(genericTypes);
    }

    public static TypeTag of(Field field, TypeTag enclosingType) {
        Optional<TypeTag> opt;
        if (KotlinScreen.isKotlin(enclosingType.getType()) && KotlinScreen.isKotlinLazy(field) && (opt = KotlinProbe.determineLazyType(enclosingType.getType(), field)).isPresent()) {
            return opt.get();
        }
        return TypeTag.resolve(field.getGenericType(), field.getType(), enclosingType, false);
    }

    private static TypeTag resolve(Type type, Class<?> typeAsClass, TypeTag enclosingType, boolean shortCircuitRecursiveTypeBound) {
        ArrayList<TypeTag> nestedTags = new ArrayList<TypeTag>();
        if (type instanceof Class) {
            Class cls = (Class)type;
            return TypeTag.processClass(cls, nestedTags);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return TypeTag.processParameterizedType(parameterizedType, typeAsClass, enclosingType, nestedTags, shortCircuitRecursiveTypeBound);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return TypeTag.processGenericArray(arrayType, typeAsClass, enclosingType);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return TypeTag.processWildcard(wildcardType, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound);
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            return TypeTag.processTypeVariable(variable, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound);
        }
        throw new EqualsVerifierInternalBugException("Failed to tag type " + type.toString() + " (" + String.valueOf(type.getClass()) + ")");
    }

    private static TypeTag processClass(Class<?> type, List<TypeTag> nestedTags) {
        return new TypeTag(type, nestedTags);
    }

    private static TypeTag processParameterizedType(ParameterizedType type, Class<?> typeAsClass, TypeTag enclosingType, List<TypeTag> nestedTags, boolean shortCircuitRecursiveTypeBound) {
        Type[] typeArgs;
        for (Type typeArg : typeArgs = type.getActualTypeArguments()) {
            nestedTags.add(TypeTag.resolve(typeArg, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound));
        }
        return new TypeTag((Class)type.getRawType(), nestedTags);
    }

    private static TypeTag processGenericArray(GenericArrayType type, Class<?> typeAsClass, TypeTag enclosingType) {
        TypeTag tag = TypeTag.resolve(type.getGenericComponentType(), typeAsClass, enclosingType, false);
        String arrayTypeName = "[L" + tag.getType().getName() + ";";
        Class arrayType = Util.classForName(arrayTypeName);
        return new TypeTag(arrayType, tag.genericTypes());
    }

    private static TypeTag processWildcard(WildcardType type, Class<?> typeAsClass, TypeTag enclosingType, boolean shortCircuitRecursiveTypeBound) {
        int n = 0;
        Type[] typeArray = type.getLowerBounds();
        int n2 = typeArray.length;
        if (n < n2) {
            Type type2 = typeArray[n];
            return TypeTag.resolve(type2, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound);
        }
        for (Type type3 : type.getUpperBounds()) {
            TypeTag upper = TypeTag.resolve(type3, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound);
            if (Object.class.equals(upper.getType())) continue;
            return upper;
        }
        for (Type type4 : typeAsClass.getTypeParameters()) {
            for (Type b : type4.getBounds()) {
                if (shortCircuitRecursiveTypeBound) continue;
                return TypeTag.resolve(b, typeAsClass, enclosingType, true);
            }
        }
        return new TypeTag(Object.class, new TypeTag[0]);
    }

    private static TypeTag processTypeVariable(TypeVariable<?> type, Class<?> typeAsClass, TypeTag enclosingType, boolean shortCircuitRecursiveTypeBound) {
        String typeVariableName;
        Map<String, TypeTag> typeVariableLookup = TypeTag.buildLookup(enclosingType);
        if (typeVariableLookup.containsKey(typeVariableName = type.getName())) {
            return typeVariableLookup.get(typeVariableName);
        }
        for (Type b : type.getBounds()) {
            if (shortCircuitRecursiveTypeBound) continue;
            return TypeTag.resolve(b, typeAsClass, enclosingType, true);
        }
        return new TypeTag(Object.class, new TypeTag[0]);
    }

    private static Map<String, TypeTag> buildLookup(TypeTag enclosingType) {
        TypeVariable<Class<T>>[] typeParameters = enclosingType.getType().getTypeParameters();
        if (enclosingType.genericTypes().size() == 0) {
            return Map.of();
        }
        HashMap<String, TypeTag> lookup = new HashMap<String, TypeTag>();
        for (int i = 0; i < typeParameters.length; ++i) {
            String name = typeParameters[i].getName();
            TypeTag tag = enclosingType.genericTypes().get(i);
            lookup.put(name, tag);
        }
        return lookup;
    }

    public <T> Class<T> getType() {
        return this.type;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("");
        s.append(this.type.getSimpleName());
        if (this.genericTypes.size() >= 1) {
            s.append("<");
            s.append(this.genericTypes.get(0));
        }
        for (int i = 1; i < this.genericTypes.size(); ++i) {
            s.append(", ");
            s.append(this.genericTypes.get(i));
        }
        if (this.genericTypes.size() >= 1) {
            s.append(">");
        }
        return s.toString();
    }

    private static final class NullType {
        private NullType() {
        }
    }
}

