/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.lexemmens.podman.AbstractPodmanMojo;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;

public abstract class AbstractCatalogSupport
extends AbstractPodmanMojo {
    @Parameter(defaultValue="${repositorySystemSession}", required=true)
    public RepositorySystemSession repositorySystemSession;
    @Component
    public EnhancedLocalRepositoryManagerFactory localRepositoryManagerFactory;
    @Component
    public RepositorySystem repositorySystem;

    protected List<String> readLocalCatalog() throws MojoExecutionException {
        String catalogFileName = String.format("%s.txt", "container-catalog");
        Path catalogPath = Paths.get(this.project.getBuild().getDirectory(), catalogFileName);
        return this.readCatalogContent(catalogPath, true);
    }

    protected List<String> readRemoteCatalog(RepositorySystemSession repositorySystemSession) throws MojoExecutionException {
        List<RemoteRepository> remoteRepositories = this.getRemoteRepositories();
        try {
            DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), "container-catalog", "txt", this.project.getVersion());
            ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)artifact, remoteRepositories, null);
            ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(repositorySystemSession, artifactRequest);
            if (artifactResult.isMissing()) {
                return Collections.emptyList();
            }
            if (artifactResult.isResolved()) {
                return this.readCatalogContent(Paths.get(artifactResult.getArtifact().getFile().toURI()), false);
            }
            throw new MojoExecutionException("Failed to resolve the container catalog file.");
        }
        catch (ArtifactResolutionException e) {
            if (e.getCause() instanceof ArtifactNotFoundException) {
                return Collections.emptyList();
            }
            throw new MojoExecutionException("Failed retrieving container catalog file", (Exception)((Object)e));
        }
    }

    private List<String> readCatalogContent(Path catalogPath, boolean local) throws MojoExecutionException {
        if (Files.exists(catalogPath, new LinkOption[0])) {
            List<String> list;
            block10: {
                Stream<String> catalogStream = Files.lines(catalogPath);
                try {
                    list = catalogStream.skip(1L).collect(Collectors.toList());
                    if (catalogStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (catalogStream != null) {
                            try {
                                catalogStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        String msg = "Failed to read container catalog.";
                        if (local) {
                            msg = msg + " Make sure the build goal is executed.";
                        }
                        this.getLog().error((CharSequence)msg);
                        throw new MojoExecutionException(msg, (Exception)e);
                    }
                }
                catalogStream.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    protected List<RemoteRepository> getRemoteRepositories() throws MojoExecutionException {
        ArrayList<ArtifactRepository> remoteArtifactRepositories;
        String sourceCatalogRepository = this.skopeo.getCopy().getSourceCatalogRepository();
        if (sourceCatalogRepository == null) {
            this.getLog().info((CharSequence)"Using all remote repositories to find container catalog.");
            remoteArtifactRepositories = this.project.getRemoteArtifactRepositories();
        } else {
            Optional<ArtifactRepository> repository = this.project.getRemoteArtifactRepositories().stream().filter(repo -> repo.getId().equals(sourceCatalogRepository)).findFirst();
            if (repository.isPresent()) {
                this.getLog().info((CharSequence)("Using repository " + repository.get() + " for finding container catalog."));
                remoteArtifactRepositories = new ArrayList();
                remoteArtifactRepositories.add(repository.get());
            } else {
                if (this.skopeo.getCopy().getDisableLocal()) {
                    throw new MojoExecutionException("Cannot resolve artifacts from 'null' repository if the local repository is also disabled.");
                }
                this.getLog().debug((CharSequence)"Resolving container images via catalog from local repository only.");
                remoteArtifactRepositories = new ArrayList<ArtifactRepository>();
            }
        }
        return RepositoryUtils.toRepos((List)remoteArtifactRepositories);
    }

    protected PodmanSession getTempSession(boolean disableLocalRepo) {
        DefaultRepositorySystemSession tempSession = new DefaultRepositorySystemSession(this.repositorySystemSession);
        tempSession.setUpdatePolicy("always");
        File tempRepo = null;
        if (disableLocalRepo) {
            this.getLog().info((CharSequence)("Disabling local repository @ " + tempSession.getLocalRepository().getBasedir()));
            try {
                tempRepo = Files.createTempDirectory("podman-maven-plugin-repo", new FileAttribute[0]).toFile();
                this.getLog().info((CharSequence)("Using temporary local repository @ " + tempRepo.getAbsolutePath()));
                tempSession.setLocalRepositoryManager(this.localRepositoryManagerFactory.newInstance((RepositorySystemSession)tempSession, new LocalRepository(tempRepo)));
            }
            catch (IOException | NoLocalRepositoryManagerException e) {
                this.getLog().warn((CharSequence)"Failed to disable local repository path.", e);
            }
        }
        tempSession.setReadOnly();
        return new PodmanSession(tempSession, tempRepo);
    }

    public static final class PodmanSession {
        public final DefaultRepositorySystemSession session;
        public final File repo;

        public PodmanSession(DefaultRepositorySystemSession session, File repo) {
            this.session = session;
            this.repo = repo;
        }
    }
}

