/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.lexemmens.podman.AbstractCatalogSupport;
import nl.lexemmens.podman.service.ServiceHub;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystemSession;

@Mojo(name="copy", defaultPhase=LifecyclePhase.DEPLOY)
public class CopyMojo
extends AbstractCatalogSupport {
    @Parameter(property="skopeo.skip.copy", defaultValue="false")
    boolean skipCopy;

    @Override
    public void executeInternal(ServiceHub hub) throws MojoExecutionException {
        this.checkAuthentication(hub);
        this.performCopyUsingCatalogFile(hub);
    }

    @Override
    protected boolean skipGoal() {
        return this.skipCopy;
    }

    @Override
    protected boolean requireImageConfiguration() {
        return false;
    }

    private void copyImage(ServiceHub hub, String sourceImage, String targetImage) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Copying image %s to %s...", sourceImage, targetImage));
        hub.getSkopeoExecutorService().copy(sourceImage, targetImage);
    }

    private void performCopyUsingCatalogFile(ServiceHub hub) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Using container-catalog.txt to perform Skopeo copy.");
        AbstractCatalogSupport.PodmanSession tempSession = this.getTempSession(this.skopeo.getCopy().getDisableLocal());
        File tempRepo = tempSession.repo;
        List<String> cataloguedImages = this.readRemoteCatalog((RepositorySystemSession)tempSession.session);
        if (cataloguedImages.isEmpty()) {
            this.getLog().info((CharSequence)"Not copying container images, because no container-catalog.txt artifact was found.");
        } else {
            Map<String, String> transformedImages = this.performTransformation(cataloguedImages);
            for (Map.Entry<String, String> imageEntry : transformedImages.entrySet()) {
                this.copyImage(hub, imageEntry.getKey(), imageEntry.getValue());
            }
            if (this.skopeo.getCopy().getDisableLocal() && tempRepo != null) {
                try {
                    FileUtils.deleteDirectory((File)tempRepo);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Failed to cleanup temporary repository directory: " + tempRepo));
                }
            }
        }
    }

    private String transformToTargetImageRepo(String sourceImageRepo) {
        return sourceImageRepo.replace(this.skopeo.getCopy().getSearchString(), this.skopeo.getCopy().getReplaceString());
    }

    private Map<String, String> performTransformation(List<String> cataloguedImages) {
        HashMap<String, String> transformedImages = new HashMap<String, String>(cataloguedImages.size());
        for (String image : cataloguedImages) {
            transformedImages.put(image, this.transformToTargetImageRepo(image));
        }
        return transformedImages;
    }
}

