/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import nl.lexemmens.podman.AbstractPodmanMojo;
import nl.lexemmens.podman.config.image.StageConfiguration;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;
import nl.lexemmens.podman.service.ServiceHub;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="save", defaultPhase=LifecyclePhase.NONE)
public class SaveMojo
extends AbstractPodmanMojo {
    @Parameter(property="podman.skip.save", defaultValue="false")
    boolean skipSave;
    @Parameter(property="podman.save.directory", defaultValue="${project.build.directory}/podman")
    File targetDirectory;

    @Override
    public void executeInternal(ServiceHub hub) throws MojoExecutionException {
        this.checkAuthentication(hub);
        for (SingleImageConfiguration image : this.resolvedImages) {
            if (!image.isValid()) {
                this.getLog().warn((CharSequence)("Skipping save of container image with name " + image.getImageName() + ". Configuration is not valid for this module!"));
                continue;
            }
            this.exportContainerImages(image, hub);
        }
    }

    @Override
    protected boolean skipGoal() {
        return this.skipSave;
    }

    private void exportContainerImages(SingleImageConfiguration image, ServiceHub hub) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Exporting container images to local disk ...");
        Path targetPodmanDir = this.targetDirectory.toPath().normalize().toAbsolutePath();
        this.createTargetFolder(targetPodmanDir);
        if (image.getBuild().isMultistageContainerFile() && image.useCustomImageNameForMultiStageContainerfile()) {
            for (StageConfiguration stage : image.getStages()) {
                for (String imageNameWithTag : image.getImageNamesByStage(stage.getName())) {
                    this.doExportContainerImage(hub, imageNameWithTag, targetPodmanDir);
                }
            }
        } else if (image.getBuild().isMultistageContainerFile()) {
            this.getLog().warn((CharSequence)"Detected multistage Containerfile, but no custom image names have been specified. Falling back to exporting final image.");
            this.exportContainerImage(image, hub, targetPodmanDir);
        } else {
            this.exportContainerImage(image, hub, targetPodmanDir);
        }
        this.getLog().info((CharSequence)"Container images exported successfully.");
    }

    private void exportContainerImage(SingleImageConfiguration image, ServiceHub hub, Path targetPodmanDir) throws MojoExecutionException {
        for (String imageNameWithTag : image.getImageNames()) {
            this.doExportContainerImage(hub, imageNameWithTag, targetPodmanDir);
        }
    }

    private void doExportContainerImage(ServiceHub hub, String imageNameWithTag, Path targetPodmanDir) throws MojoExecutionException {
        String fullImageName = this.getFullImageNameWithPushRegistry(imageNameWithTag);
        String archiveName = String.format("%s.tar.gz", this.normaliseImageName(imageNameWithTag));
        Path saveImageTargetPath = targetPodmanDir.resolve(archiveName).normalize();
        this.getLog().info((CharSequence)("Exporting image " + imageNameWithTag + " to " + saveImageTargetPath));
        hub.getPodmanExecutorService().save(saveImageTargetPath.toString(), fullImageName);
    }

    private void createTargetFolder(Path targetPodmanDir) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)("Creating directory if not exists: " + targetPodmanDir.toString()));
            Files.createDirectories(targetPodmanDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            String msg = "Failed to create directory '" + targetPodmanDir + "'. An IOException occurred: " + e.getMessage();
            this.getLog().error((CharSequence)msg, (Throwable)e);
            throw new MojoExecutionException(msg, (Exception)e);
        }
    }

    private String normaliseImageName(String fullImageName) {
        String[] imageNameParts = fullImageName.split("\\/");
        String tagAndVersion = imageNameParts[imageNameParts.length - 1];
        return tagAndVersion.replaceAll("[\\.\\/\\-\\*:]", "_");
    }
}

