/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.config.image.batch;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.lexemmens.podman.config.image.AbstractImageBuildConfiguration;
import org.apache.maven.plugin.MojoExecutionException;

public class BatchImageBuildConfiguration
extends AbstractImageBuildConfiguration {
    public List<Path> getAllContainerFiles() throws MojoExecutionException {
        List<Path> allContainerFiles;
        try (Stream<Path> pathStream = Files.walk(Paths.get(this.containerFileDir.toURI()), new FileVisitOption[0]);){
            allContainerFiles = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().equals(this.containerFile)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to find Containerfiles with name '" + this.containerFile + "' in directory " + this.containerFileDir, (Exception)e);
        }
        return allContainerFiles;
    }

    protected String[] getTags() {
        return this.tags;
    }

    protected boolean isTagWithMavenProjectVersion() {
        return this.tagWithMavenProjectVersion;
    }
}

