/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.config.podman;

import java.io.File;
import nl.lexemmens.podman.enumeration.CGroupManager;
import nl.lexemmens.podman.enumeration.TlsVerify;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public class PodmanConfiguration {
    @Parameter(property="podman.tls.verify", defaultValue="NOT_SPECIFIED", required=true)
    protected TlsVerify tlsVerify;
    @Parameter(property="podman.cgroup.manager")
    protected CGroupManager cgroupManager;
    @Parameter(property="podman.root")
    protected File root;
    @Parameter(property="podman.run.root")
    protected File runRoot;
    @Parameter(property="podman.run.dir")
    protected File runDirectory;

    public TlsVerify getTlsVerify() {
        return this.tlsVerify;
    }

    public File getRoot() {
        return this.root;
    }

    public File getRunRoot() {
        return this.runRoot;
    }

    public File getRunDirectory() {
        return this.runDirectory;
    }

    public CGroupManager getCgroupManager() {
        return this.cgroupManager;
    }

    public void initAndValidate(MavenProject project, Log log) {
        if (this.tlsVerify == null) {
            log.debug((CharSequence)"Setting TLS Verify to NOT_SPECIFIED");
            this.tlsVerify = TlsVerify.NOT_SPECIFIED;
        } else {
            log.info((CharSequence)("Setting tlsVerify to: " + this.tlsVerify.name()));
        }
        if (this.root == null) {
            log.debug((CharSequence)"Using Podman's default settings for --root.");
        } else {
            log.info((CharSequence)("Setting Podman's 'root' directory to: " + this.root.getAbsolutePath()));
        }
        if (this.runRoot == null) {
            log.debug((CharSequence)"Using Podman's default settings for --runroot.");
        } else {
            log.info((CharSequence)("Setting Podman's 'runroot' directory to: " + this.runRoot.getAbsolutePath()));
        }
        if (this.runDirectory == null) {
            log.debug((CharSequence)"Executing Podman from the module's directory.");
            this.runDirectory = project.getBasedir();
        } else {
            log.info((CharSequence)("Setting Podman's run directory " + this.runDirectory.getAbsolutePath()));
        }
    }
}

